/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.stats.NullStatsLogger;
import dlshade.org.apache.distributedlog.DLSN;
import dlshade.org.apache.distributedlog.EntryBuffer;
import dlshade.org.apache.distributedlog.EnvelopedEntryReader;
import dlshade.org.apache.distributedlog.EnvelopedEntryWriter;
import dlshade.org.apache.distributedlog.LogRecord;
import dlshade.org.apache.distributedlog.LogRecordWithDLSN;
import dlshade.org.apache.distributedlog.exceptions.LogRecordTooLongException;
import dlshade.org.apache.distributedlog.exceptions.WriteException;
import dlshade.org.apache.distributedlog.io.CompressionCodec;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class Entry {
    public static Writer newEntry(String logName, int initialBufferSize, boolean envelopeBeforeTransmit, CompressionCodec.Type codec) {
        return new EnvelopedEntryWriter(logName, initialBufferSize, envelopeBeforeTransmit, codec);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static interface Reader {
        public long getLSSN();

        public long getEntryId();

        public LogRecordWithDLSN nextRecord() throws IOException;

        public boolean skipTo(long var1) throws IOException;

        public boolean skipTo(DLSN var1) throws IOException;

        public void release();
    }

    public static interface Writer
    extends EntryBuffer {
        public void writeRecord(LogRecord var1, CompletableFuture<DLSN> var2) throws LogRecordTooLongException, WriteException;
    }

    public static class Builder {
        private long logSegmentSequenceNumber = -1L;
        private long entryId = -1L;
        private long startSequenceId = Long.MIN_VALUE;
        private boolean envelopeEntry = true;
        private ByteBuf buffer;
        private boolean deserializeRecordSet = true;

        private Builder() {
        }

        public Builder setLogSegmentInfo(long lssn, long startSequenceId) {
            this.logSegmentSequenceNumber = lssn;
            this.startSequenceId = startSequenceId;
            return this;
        }

        public Builder setEntryId(long entryId) {
            this.entryId = entryId;
            return this;
        }

        public Builder setEnvelopeEntry(boolean enabled) {
            this.envelopeEntry = enabled;
            return this;
        }

        public Builder setEntry(ByteBuf buffer) {
            this.buffer = buffer.retainedSlice();
            return this;
        }

        public Builder deserializeRecordSet(boolean enabled) {
            this.deserializeRecordSet = enabled;
            return this;
        }

        public Reader buildReader() throws IOException {
            Preconditions.checkNotNull(this.buffer, "Serialized data or input stream isn't provided");
            return new EnvelopedEntryReader(this.logSegmentSequenceNumber, this.entryId, this.startSequenceId, this.buffer, this.envelopeEntry, this.deserializeRecordSet, NullStatsLogger.INSTANCE);
        }
    }
}

