/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.distributedlog.DLSN;
import dlshade.org.apache.distributedlog.EnvelopedRecordSetReader;
import dlshade.org.apache.distributedlog.EnvelopedRecordSetWriter;
import dlshade.org.apache.distributedlog.LogRecord;
import dlshade.org.apache.distributedlog.LogRecordSetBuffer;
import dlshade.org.apache.distributedlog.LogRecordWithDLSN;
import dlshade.org.apache.distributedlog.exceptions.LogRecordTooLongException;
import dlshade.org.apache.distributedlog.exceptions.WriteException;
import dlshade.org.apache.distributedlog.io.CompressionCodec;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;

public class LogRecordSet {
    public static final int HEADER_LEN = 16;
    static final int VERSION = 4096;
    static final int METADATA_OFFSET = 0;
    static final int COUNT_OFFSET = 4;
    static final int DECOMPRESSED_SIZE_OFFSET = 8;
    static final int COMPRESSED_SIZE_OFFSET = 12;
    static final int METADATA_VERSION_MASK = 61440;
    static final int METADATA_COMPRESSION_MASK = 3;

    public static int numRecords(LogRecord record) throws IOException {
        Preconditions.checkArgument(record.isRecordSet(), "record is not a recordset");
        ByteBuf buffer = record.getPayloadBuf();
        int metadata = buffer.getInt(0);
        int version = metadata & 0xF000;
        if (version != 4096) {
            throw new IOException(String.format("Version mismatch while reading. Received: %d, Required: %d", version, 4096));
        }
        return buffer.getInt(4);
    }

    public static Writer newWriter(int initialBufferSize, CompressionCodec.Type codec) {
        return new EnvelopedRecordSetWriter(initialBufferSize, codec);
    }

    public static Reader of(LogRecordWithDLSN record) throws IOException {
        Preconditions.checkArgument(record.isRecordSet(), "record is not a recordset");
        DLSN dlsn = record.getDlsn();
        int startPosition = record.getPositionWithinLogSegment();
        long startSequenceId = record.getStartSequenceIdOfCurrentSegment();
        return new EnvelopedRecordSetReader(dlsn.getLogSegmentSequenceNo(), dlsn.getEntryId(), record.getTransactionId(), dlsn.getSlotId(), startPosition, startSequenceId, record.getPayloadBuf());
    }

    public static interface Reader {
        public LogRecordWithDLSN nextRecord() throws IOException;

        public void release();
    }

    public static interface Writer
    extends LogRecordSetBuffer {
        public void writeRecord(ByteBuffer var1, CompletableFuture<DLSN> var2) throws LogRecordTooLongException, WriteException;
    }
}

