/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog;

import dlshade.com.google.common.annotations.VisibleForTesting;
import dlshade.org.apache.distributedlog.DLSN;
import dlshade.org.apache.distributedlog.LogRecord;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class LogRecordWithDLSN
extends LogRecord {
    private final DLSN dlsn;
    private final long startSequenceIdOfCurrentSegment;

    LogRecordWithDLSN(DLSN dlsn, long startSequenceIdOfCurrentSegment) {
        this.dlsn = dlsn;
        this.startSequenceIdOfCurrentSegment = startSequenceIdOfCurrentSegment;
    }

    @VisibleForTesting
    public LogRecordWithDLSN(DLSN dlsn, long txid, byte[] data, long startSequenceIdOfCurrentSegment) {
        super(txid, data);
        this.dlsn = dlsn;
        this.startSequenceIdOfCurrentSegment = startSequenceIdOfCurrentSegment;
    }

    @VisibleForTesting
    public LogRecordWithDLSN(DLSN dlsn, long txid, ByteBuf buffer, long startSequenceIdOfCurrentSegment) {
        super(txid, Unpooled.copiedBuffer((ByteBuf)buffer));
        this.dlsn = dlsn;
        this.startSequenceIdOfCurrentSegment = startSequenceIdOfCurrentSegment;
    }

    long getStartSequenceIdOfCurrentSegment() {
        return this.startSequenceIdOfCurrentSegment;
    }

    public long getSequenceId() {
        return this.startSequenceIdOfCurrentSegment + (long)this.getPositionWithinLogSegment() - 1L;
    }

    public DLSN getDlsn() {
        return this.dlsn;
    }

    public String toString() {
        return "LogRecordWithDLSN{dlsn=" + this.dlsn + ", txid=" + this.getTransactionId() + ", position=" + this.getPositionWithinLogSegment() + ", isControl=" + this.isControl() + ", isEndOfStream=" + this.isEndOfStream() + '}';
    }
}

