/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog.api.namespace;

import dlshade.com.google.common.base.Preconditions;
import dlshade.org.apache.bookkeeper.common.annotation.InterfaceAudience;
import dlshade.org.apache.bookkeeper.common.annotation.InterfaceStability;
import dlshade.org.apache.bookkeeper.common.util.OrderedScheduler;
import dlshade.org.apache.bookkeeper.feature.Feature;
import dlshade.org.apache.bookkeeper.feature.FeatureProvider;
import dlshade.org.apache.bookkeeper.feature.SettableFeatureProvider;
import dlshade.org.apache.bookkeeper.stats.NullStatsLogger;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.distributedlog.BKDistributedLogNamespace;
import dlshade.org.apache.distributedlog.DistributedLogConfiguration;
import dlshade.org.apache.distributedlog.api.namespace.Namespace;
import dlshade.org.apache.distributedlog.common.util.PermitLimiter;
import dlshade.org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import dlshade.org.apache.distributedlog.feature.CoreFeatureKeys;
import dlshade.org.apache.distributedlog.injector.AsyncFailureInjector;
import dlshade.org.apache.distributedlog.injector.AsyncRandomFailureInjector;
import dlshade.org.apache.distributedlog.namespace.NamespaceDriver;
import dlshade.org.apache.distributedlog.namespace.NamespaceDriverManager;
import dlshade.org.apache.distributedlog.util.ConfUtils;
import dlshade.org.apache.distributedlog.util.DLUtils;
import dlshade.org.apache.distributedlog.util.SimplePermitLimiter;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class NamespaceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(NamespaceBuilder.class);
    private DistributedLogConfiguration _conf = null;
    private DynamicDistributedLogConfiguration _dynConf = null;
    private URI _uri = null;
    private StatsLogger _statsLogger = NullStatsLogger.INSTANCE;
    private StatsLogger _perLogStatsLogger = NullStatsLogger.INSTANCE;
    private FeatureProvider _featureProvider = null;
    private String _clientId = "Unknown-ClientId";
    private int _regionId = 0;

    public static NamespaceBuilder newBuilder() {
        return new NamespaceBuilder();
    }

    private NamespaceBuilder() {
    }

    public NamespaceBuilder conf(DistributedLogConfiguration conf) {
        this._conf = conf;
        return this;
    }

    public NamespaceBuilder dynConf(DynamicDistributedLogConfiguration dynConf) {
        this._dynConf = dynConf;
        return this;
    }

    public NamespaceBuilder uri(URI uri) {
        this._uri = uri;
        return this;
    }

    public NamespaceBuilder statsLogger(StatsLogger statsLogger) {
        this._statsLogger = statsLogger;
        return this;
    }

    public NamespaceBuilder perLogStatsLogger(StatsLogger statsLogger) {
        this._perLogStatsLogger = statsLogger;
        return this;
    }

    public NamespaceBuilder featureProvider(FeatureProvider featureProvider) {
        this._featureProvider = featureProvider;
        return this;
    }

    public NamespaceBuilder clientId(String clientId) {
        this._clientId = clientId;
        return this;
    }

    public NamespaceBuilder regionId(int regionId) {
        this._regionId = regionId;
        return this;
    }

    private static StatsLogger normalizePerLogStatsLogger(StatsLogger statsLogger, StatsLogger perLogStatsLogger, DistributedLogConfiguration conf) {
        StatsLogger normalizedPerLogStatsLogger = perLogStatsLogger;
        if (perLogStatsLogger == NullStatsLogger.INSTANCE && conf.getEnablePerStreamStat()) {
            normalizedPerLogStatsLogger = statsLogger.scope("stream");
        }
        return normalizedPerLogStatsLogger;
    }

    public Namespace build() throws IllegalArgumentException, NullPointerException, IOException {
        PermitLimiter writeLimiter;
        FeatureProvider featureProvider;
        Preconditions.checkNotNull(this._conf, "No DistributedLog Configuration.");
        Preconditions.checkNotNull(this._uri, "No DistributedLog URI");
        this._conf.validate();
        if (null == this._dynConf) {
            this._dynConf = ConfUtils.getConstDynConf(this._conf);
        }
        NamespaceDriver driver = NamespaceDriverManager.getDriver(this._uri);
        URI normalizedUri = DLUtils.normalizeURI(this._uri);
        if (null == this._featureProvider) {
            featureProvider = new SettableFeatureProvider("", 0);
            logger.info("No feature provider is set. All features are disabled now.");
        } else {
            featureProvider = this._featureProvider;
        }
        AsyncFailureInjector failureInjector = AsyncRandomFailureInjector.newBuilder().injectDelays(this._conf.getEIInjectReadAheadDelay(), this._conf.getEIInjectReadAheadDelayPercent(), this._conf.getEIInjectMaxReadAheadDelayMs()).injectErrors(false, 10).injectStops(this._conf.getEIInjectReadAheadStall(), 10).injectCorruption(this._conf.getEIInjectReadAheadBrokenEntries()).build();
        StatsLogger perLogStatsLogger = NamespaceBuilder.normalizePerLogStatsLogger(this._statsLogger, this._perLogStatsLogger, this._conf);
        OrderedScheduler scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("DLM-" + normalizedUri.getPath()).numThreads(this._conf.getNumWorkerThreads()).build();
        driver.initialize(this._conf, this._dynConf, normalizedUri, scheduler, featureProvider, failureInjector, this._statsLogger, perLogStatsLogger, DLUtils.normalizeClientId(this._clientId), this._regionId);
        if (this._conf.getGlobalOutstandingWriteLimit() < 0) {
            writeLimiter = PermitLimiter.NULL_PERMIT_LIMITER;
        } else {
            Feature disableWriteLimitFeature = featureProvider.getFeature(CoreFeatureKeys.DISABLE_WRITE_LIMIT.name().toLowerCase());
            writeLimiter = new SimplePermitLimiter(this._conf.getOutstandingWriteLimitDarkmode(), this._conf.getGlobalOutstandingWriteLimit(), this._statsLogger.scope("writeLimiter"), true, disableWriteLimitFeature);
        }
        return new BKDistributedLogNamespace(this._conf, normalizedUri, driver, scheduler, featureProvider, writeLimiter, failureInjector, this._statsLogger, perLogStatsLogger, DLUtils.normalizeClientId(this._clientId), this._regionId);
    }
}

