/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog.bk;

import dlshade.org.apache.bookkeeper.client.LedgerHandle;
import dlshade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import dlshade.org.apache.distributedlog.bk.LedgerAllocator;
import dlshade.org.apache.distributedlog.util.Transaction;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class LedgerAllocatorDelegator
implements LedgerAllocator {
    private final LedgerAllocator allocator;
    private final boolean ownAllocator;

    public LedgerAllocatorDelegator(LedgerAllocator allocator, boolean ownAllocator) throws IOException {
        this.allocator = allocator;
        this.ownAllocator = ownAllocator;
        if (this.ownAllocator) {
            this.allocator.start();
        }
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public CompletableFuture<Void> delete() {
        return FutureUtils.exception(new UnsupportedOperationException("Can't delete an allocator by delegator"));
    }

    @Override
    public void allocate() throws IOException {
        this.allocator.allocate();
    }

    @Override
    public CompletableFuture<LedgerHandle> tryObtain(Transaction<Object> txn, Transaction.OpListener<LedgerHandle> listener) {
        return this.allocator.tryObtain(txn, listener);
    }

    @Override
    public CompletableFuture<Void> asyncClose() {
        if (this.ownAllocator) {
            return this.allocator.asyncClose();
        }
        return FutureUtils.value(null);
    }
}

