/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog.common.rate;

import dlshade.org.apache.distributedlog.common.rate.MovingAverageRate;
import dlshade.org.apache.distributedlog.common.rate.SampledMovingAverageRate;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class MovingAverageRateFactory
implements Runnable {
    private static final int DEFAULT_INTERVAL_SECS = 1;
    private final ScheduledExecutorService scheduler;
    private final ScheduledFuture<?> scheduledFuture;
    private final CopyOnWriteArrayList<SampledMovingAverageRate> avgs = new CopyOnWriteArrayList();

    public MovingAverageRateFactory(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
        this.scheduledFuture = this.scheduler.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.SECONDS);
    }

    public MovingAverageRate create(int intervalSecs) {
        SampledMovingAverageRate avg = new SampledMovingAverageRate(intervalSecs);
        this.avgs.add(avg);
        return avg;
    }

    public void close() {
        this.scheduledFuture.cancel(true);
        this.avgs.clear();
    }

    @Override
    public void run() {
        this.sampleAll();
    }

    private void sampleAll() {
        this.avgs.forEach(SampledMovingAverageRate::sample);
    }
}

