/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog.feature;

import dlshade.com.google.common.base.Preconditions;
import dlshade.com.google.common.collect.Lists;
import dlshade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import dlshade.org.apache.bookkeeper.feature.Feature;
import dlshade.org.apache.bookkeeper.feature.FeatureProvider;
import dlshade.org.apache.bookkeeper.feature.SettableFeature;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.distributedlog.DistributedLogConfiguration;
import dlshade.org.apache.distributedlog.common.config.ConcurrentBaseConfiguration;
import dlshade.org.apache.distributedlog.common.config.ConfigurationListener;
import dlshade.org.apache.distributedlog.common.config.ConfigurationSubscription;
import dlshade.org.apache.distributedlog.common.config.FileConfigurationBuilder;
import dlshade.org.apache.distributedlog.common.config.PropertiesConfigurationBuilder;
import dlshade.org.apache.distributedlog.feature.AbstractFeatureProvider;
import dlshade.org.apache.distributedlog.feature.ConfigurationFeatureProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConfigurationFeatureProvider
extends AbstractFeatureProvider
implements ConfigurationListener {
    private static final Logger logger = LoggerFactory.getLogger(DynamicConfigurationFeatureProvider.class);
    private final ConcurrentBaseConfiguration featuresConf;
    private ConfigurationSubscription featuresConfSubscription;
    private final ConcurrentMap<String, SettableFeature> features = new ConcurrentHashMap<String, SettableFeature>();
    private final ScheduledExecutorService executorService;

    public DynamicConfigurationFeatureProvider(String rootScope, DistributedLogConfiguration conf, StatsLogger statsLogger) {
        super(rootScope, conf, statsLogger);
        this.featuresConf = new ConcurrentBaseConfiguration();
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("DynamicConfigurationFeatureProvider-%d").build());
    }

    ConcurrentBaseConfiguration getFeatureConf() {
        return this.featuresConf;
    }

    ConfigurationSubscription getFeatureConfSubscription() {
        return this.featuresConfSubscription;
    }

    @Override
    public void start() throws IOException {
        ArrayList<FileConfigurationBuilder> fileConfigBuilders = Lists.newArrayListWithExpectedSize(2);
        String baseConfigPath = this.conf.getFileFeatureProviderBaseConfigPath();
        Preconditions.checkNotNull(baseConfigPath);
        File baseConfigFile = new File(baseConfigPath);
        PropertiesConfigurationBuilder baseProperties = new PropertiesConfigurationBuilder(baseConfigFile.toURI().toURL());
        fileConfigBuilders.add(baseProperties);
        String overlayConfigPath = this.conf.getFileFeatureProviderOverlayConfigPath();
        if (null != overlayConfigPath) {
            File overlayConfigFile = new File(overlayConfigPath);
            PropertiesConfigurationBuilder overlayProperties = new PropertiesConfigurationBuilder(overlayConfigFile.toURI().toURL());
            fileConfigBuilders.add(overlayProperties);
        }
        try {
            this.featuresConfSubscription = new ConfigurationSubscription(this.featuresConf, fileConfigBuilders, this.executorService, this.conf.getDynamicConfigReloadIntervalSec(), TimeUnit.SECONDS);
        }
        catch (ConfigurationException e) {
            throw new IOException("Failed to register subscription on features configuration");
        }
        this.featuresConfSubscription.registerListener(this);
    }

    @Override
    public void stop() {
        this.executorService.shutdown();
    }

    @Override
    public void onReload(ConcurrentBaseConfiguration conf) {
        for (Map.Entry feature : this.features.entrySet()) {
            String featureName = (String)feature.getKey();
            int availability = conf.getInt(featureName, 0);
            if (availability == ((SettableFeature)feature.getValue()).availability()) continue;
            ((SettableFeature)feature.getValue()).set(availability);
            logger.info("Reload feature {}={}", (Object)featureName, (Object)availability);
        }
    }

    @Override
    protected Feature makeFeature(String featureName) {
        return ConfigurationFeatureProvider.makeFeature(this.featuresConf, this.features, featureName);
    }

    @Override
    protected FeatureProvider makeProvider(String fullScopeName) {
        return new ConfigurationFeatureProvider(fullScopeName, this.featuresConf, this.features);
    }
}

