/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog.impl;

import dlshade.org.apache.distributedlog.logsegment.LogSegmentFilter;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKLogSegmentFilters {
    static final Logger LOG = LoggerFactory.getLogger(ZKLogSegmentFilters.class);
    public static final LogSegmentFilter WRITE_HANDLE_FILTER = new LogSegmentFilter(){

        @Override
        public Collection<String> filter(Collection<String> fullList) {
            ArrayList<String> result = new ArrayList<String>(fullList.size());
            String lastCompletedLogSegmentName = null;
            long lastLogSegmentSequenceNumber = -1L;
            for (String s : fullList) {
                if (s.startsWith("inprogress")) {
                    result.add(s);
                    continue;
                }
                if (s.startsWith("logrecs")) {
                    String[] parts = s.split("_");
                    try {
                        if (2 == parts.length) {
                            long logSegmentSequenceNumber = Long.parseLong(parts[1]);
                            if (logSegmentSequenceNumber <= lastLogSegmentSequenceNumber) continue;
                            lastLogSegmentSequenceNumber = logSegmentSequenceNumber;
                            lastCompletedLogSegmentName = s;
                            continue;
                        }
                        if (6 == parts.length) {
                            long logSegmentSequenceNumber = Long.parseLong(parts[3]);
                            if (logSegmentSequenceNumber <= lastLogSegmentSequenceNumber) continue;
                            lastLogSegmentSequenceNumber = logSegmentSequenceNumber;
                            lastCompletedLogSegmentName = s;
                            continue;
                        }
                        result.add(s);
                    }
                    catch (NumberFormatException nfe) {
                        LOG.warn("Unexpected sequence number in log segment {} :", (Object)s, (Object)nfe);
                        result.add(s);
                    }
                    continue;
                }
                LOG.error("Unknown log segment name : {}", (Object)s);
            }
            if (null != lastCompletedLogSegmentName) {
                result.add(lastCompletedLogSegmentName);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Filtered log segments {} from {}.", result, fullList);
            }
            return result;
        }
    };
}

