/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog.impl.logsegment;

import dlshade.org.apache.bookkeeper.client.AsyncCallback;
import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.client.BookKeeper;
import dlshade.org.apache.bookkeeper.client.LedgerHandle;
import dlshade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import dlshade.org.apache.bookkeeper.common.util.OrderedScheduler;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.distributedlog.BookKeeperClient;
import dlshade.org.apache.distributedlog.DistributedLogConfiguration;
import dlshade.org.apache.distributedlog.LogSegmentMetadata;
import dlshade.org.apache.distributedlog.ZooKeeperClient;
import dlshade.org.apache.distributedlog.bk.DynamicQuorumConfigProvider;
import dlshade.org.apache.distributedlog.bk.LedgerAllocator;
import dlshade.org.apache.distributedlog.bk.LedgerAllocatorDelegator;
import dlshade.org.apache.distributedlog.bk.LedgerMetadata;
import dlshade.org.apache.distributedlog.bk.SimpleLedgerAllocator;
import dlshade.org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import dlshade.org.apache.distributedlog.exceptions.BKTransmitException;
import dlshade.org.apache.distributedlog.impl.logsegment.BKLogSegmentAllocator;
import dlshade.org.apache.distributedlog.impl.logsegment.BKLogSegmentEntryReader;
import dlshade.org.apache.distributedlog.impl.logsegment.BKLogSegmentRandomAccessEntryReader;
import dlshade.org.apache.distributedlog.injector.AsyncFailureInjector;
import dlshade.org.apache.distributedlog.logsegment.LogSegmentEntryReader;
import dlshade.org.apache.distributedlog.logsegment.LogSegmentEntryStore;
import dlshade.org.apache.distributedlog.logsegment.LogSegmentEntryWriter;
import dlshade.org.apache.distributedlog.logsegment.LogSegmentRandomAccessEntryReader;
import dlshade.org.apache.distributedlog.metadata.LogMetadataForWriter;
import dlshade.org.apache.distributedlog.util.Allocator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BKLogSegmentEntryStore
implements LogSegmentEntryStore,
AsyncCallback.OpenCallback,
AsyncCallback.DeleteCallback {
    private static final Logger logger = LoggerFactory.getLogger(BKLogSegmentEntryReader.class);
    private final byte[] passwd;
    private final ZooKeeperClient zkc;
    private final BookKeeperClient bkc;
    private final OrderedScheduler scheduler;
    private final DistributedLogConfiguration conf;
    private final DynamicDistributedLogConfiguration dynConf;
    private final StatsLogger statsLogger;
    private final AsyncFailureInjector failureInjector;
    private final LedgerAllocator allocator;

    public BKLogSegmentEntryStore(DistributedLogConfiguration conf, DynamicDistributedLogConfiguration dynConf, ZooKeeperClient zkc, BookKeeperClient bkc, OrderedScheduler scheduler, LedgerAllocator allocator, StatsLogger statsLogger, AsyncFailureInjector failureInjector) {
        this.conf = conf;
        this.dynConf = dynConf;
        this.zkc = zkc;
        this.bkc = bkc;
        this.passwd = conf.getBKDigestPW().getBytes(StandardCharsets.UTF_8);
        this.scheduler = scheduler;
        this.allocator = allocator;
        this.statsLogger = statsLogger;
        this.failureInjector = failureInjector;
    }

    @Override
    public CompletableFuture<LogSegmentMetadata> deleteLogSegment(LogSegmentMetadata segment) {
        BookKeeper bk;
        DeleteLogSegmentRequest request = new DeleteLogSegmentRequest(segment);
        try {
            bk = this.bkc.get();
        }
        catch (IOException e) {
            return FutureUtils.exception(e);
        }
        bk.asyncDeleteLedger(segment.getLogSegmentId(), this, request);
        return request.deletePromise;
    }

    @Override
    public void deleteComplete(int rc, Object ctx) {
        DeleteLogSegmentRequest deleteRequest = (DeleteLogSegmentRequest)ctx;
        if (-25 == rc) {
            logger.warn("No ledger {} found to delete for {}.", (Object)deleteRequest.segment.getLogSegmentId(), (Object)deleteRequest.segment);
        } else if (0 != rc) {
            logger.error("Couldn't delete ledger {} from bookkeeper for {} : {}", new Object[]{deleteRequest.segment.getLogSegmentId(), deleteRequest.segment, BKException.getMessage(rc)});
            FutureUtils.completeExceptionally(deleteRequest.deletePromise, new BKTransmitException("Couldn't delete log segment " + deleteRequest.segment, rc));
            return;
        }
        FutureUtils.complete(deleteRequest.deletePromise, deleteRequest.segment);
    }

    LedgerAllocator createLedgerAllocator(LogMetadataForWriter logMetadata, DynamicDistributedLogConfiguration dynConf, LedgerMetadata ledgerMetadata) throws IOException {
        LedgerAllocator ledgerAllocatorDelegator;
        if (null == this.allocator || !dynConf.getEnableLedgerAllocatorPool()) {
            DynamicQuorumConfigProvider quorumConfigProvider = new DynamicQuorumConfigProvider(dynConf);
            SimpleLedgerAllocator allocator = new SimpleLedgerAllocator(logMetadata.getAllocationPath(), logMetadata.getAllocationData(), quorumConfigProvider, this.zkc, this.bkc, ledgerMetadata);
            ledgerAllocatorDelegator = new LedgerAllocatorDelegator(allocator, true);
        } else {
            ledgerAllocatorDelegator = this.allocator;
        }
        return ledgerAllocatorDelegator;
    }

    @Override
    public Allocator<LogSegmentEntryWriter, Object> newLogSegmentAllocator(LogMetadataForWriter logMetadata, DynamicDistributedLogConfiguration dynConf) throws IOException {
        return this.newLogSegmentAllocator(logMetadata, dynConf, null);
    }

    @Override
    public Allocator<LogSegmentEntryWriter, Object> newLogSegmentAllocator(LogMetadataForWriter logMetadata, DynamicDistributedLogConfiguration dynConf, LedgerMetadata ledgerMetadata) throws IOException {
        LedgerAllocator allocator = this.createLedgerAllocator(logMetadata, dynConf, ledgerMetadata);
        return new BKLogSegmentAllocator(allocator);
    }

    @Override
    public CompletableFuture<LogSegmentEntryReader> openReader(LogSegmentMetadata segment, long startEntryId) {
        BookKeeper bk;
        try {
            bk = this.bkc.get();
        }
        catch (IOException e) {
            return FutureUtils.exception(e);
        }
        OpenReaderRequest request = new OpenReaderRequest(segment, startEntryId);
        if (segment.isInProgress()) {
            bk.asyncOpenLedgerNoRecovery(segment.getLogSegmentId(), BookKeeper.DigestType.CRC32, this.passwd, this, request);
        } else {
            bk.asyncOpenLedger(segment.getLogSegmentId(), BookKeeper.DigestType.CRC32, this.passwd, this, request);
        }
        return request.openPromise;
    }

    @Override
    public void openComplete(int rc, LedgerHandle lh, Object ctx) {
        OpenReaderRequest request = (OpenReaderRequest)ctx;
        if (0 != rc) {
            FutureUtils.completeExceptionally(request.openPromise, new BKTransmitException("Failed to open ledger handle for log segment " + request.segment, rc));
            return;
        }
        try {
            BKLogSegmentEntryReader reader = new BKLogSegmentEntryReader(request.segment, lh, request.startEntryId, this.bkc.get(), this.scheduler, this.conf, this.statsLogger, this.failureInjector);
            FutureUtils.complete(request.openPromise, reader);
        }
        catch (IOException e) {
            FutureUtils.completeExceptionally(request.openPromise, e);
        }
    }

    @Override
    public CompletableFuture<LogSegmentRandomAccessEntryReader> openRandomAccessReader(final LogSegmentMetadata segment, boolean fence) {
        BookKeeper bk;
        try {
            bk = this.bkc.get();
        }
        catch (IOException e) {
            return FutureUtils.exception(e);
        }
        final CompletableFuture<LogSegmentRandomAccessEntryReader> openPromise = new CompletableFuture<LogSegmentRandomAccessEntryReader>();
        AsyncCallback.OpenCallback openCallback = new AsyncCallback.OpenCallback(){

            @Override
            public void openComplete(int rc, LedgerHandle lh, Object ctx) {
                if (0 != rc) {
                    FutureUtils.completeExceptionally(openPromise, new BKTransmitException("Failed to open ledger handle for log segment " + segment, rc));
                    return;
                }
                BKLogSegmentRandomAccessEntryReader reader = new BKLogSegmentRandomAccessEntryReader(segment, lh, BKLogSegmentEntryStore.this.conf);
                FutureUtils.complete(openPromise, reader);
            }
        };
        if (segment.isInProgress() && !fence) {
            bk.asyncOpenLedgerNoRecovery(segment.getLogSegmentId(), BookKeeper.DigestType.CRC32, this.passwd, openCallback, null);
        } else {
            bk.asyncOpenLedger(segment.getLogSegmentId(), BookKeeper.DigestType.CRC32, this.passwd, openCallback, null);
        }
        return openPromise;
    }

    private static class DeleteLogSegmentRequest {
        private final LogSegmentMetadata segment;
        private final CompletableFuture<LogSegmentMetadata> deletePromise;

        DeleteLogSegmentRequest(LogSegmentMetadata segment) {
            this.segment = segment;
            this.deletePromise = new CompletableFuture();
        }
    }

    private static class OpenReaderRequest {
        private final LogSegmentMetadata segment;
        private final long startEntryId;
        private final CompletableFuture<LogSegmentEntryReader> openPromise;

        OpenReaderRequest(LogSegmentMetadata segment, long startEntryId) {
            this.segment = segment;
            this.startEntryId = startEntryId;
            this.openPromise = new CompletableFuture();
        }
    }
}

