/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog.impl.logsegment;

import dlshade.com.google.common.collect.Lists;
import dlshade.org.apache.bookkeeper.client.AsyncCallback;
import dlshade.org.apache.bookkeeper.client.BKException;
import dlshade.org.apache.bookkeeper.client.LedgerHandle;
import dlshade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import dlshade.org.apache.distributedlog.common.functions.VoidFunctions;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

public class BKUtils {
    public static CompletableFuture<Void> closeLedger(LedgerHandle lh) {
        final CompletableFuture<Void> closePromise = new CompletableFuture<Void>();
        lh.asyncClose(new AsyncCallback.CloseCallback(){

            @Override
            public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
                if (0 != rc) {
                    FutureUtils.completeExceptionally(closePromise, BKException.create(rc));
                } else {
                    FutureUtils.complete(closePromise, null);
                }
            }
        }, null);
        return closePromise;
    }

    public static CompletableFuture<Void> closeLedgers(LedgerHandle ... lhs) {
        ArrayList closeResults = Lists.newArrayListWithExpectedSize(lhs.length);
        for (LedgerHandle lh : lhs) {
            closeResults.add(BKUtils.closeLedger(lh));
        }
        return FutureUtils.collect(closeResults).thenApply(VoidFunctions.LIST_TO_VOID_FUNC);
    }
}

