/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog.impl.subscription;

import dlshade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import dlshade.org.apache.distributedlog.DLSN;
import dlshade.org.apache.distributedlog.ZooKeeperClient;
import dlshade.org.apache.distributedlog.api.subscription.SubscriptionStateStore;
import dlshade.org.apache.distributedlog.exceptions.DLInterruptedException;
import dlshade.org.apache.distributedlog.util.Utils;
import dlshade.org.apache.zookeeper.AsyncCallback;
import dlshade.org.apache.zookeeper.CreateMode;
import dlshade.org.apache.zookeeper.KeeperException;
import dlshade.org.apache.zookeeper.data.Stat;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKSubscriptionStateStore
implements SubscriptionStateStore {
    private static final Logger logger = LoggerFactory.getLogger(ZKSubscriptionStateStore.class);
    private final ZooKeeperClient zooKeeperClient;
    private final String zkPath;
    private static final AtomicReferenceFieldUpdater<ZKSubscriptionStateStore, DLSN> lastCommittedPositionUpdater = AtomicReferenceFieldUpdater.newUpdater(ZKSubscriptionStateStore.class, DLSN.class, "lastCommittedPosition");
    private volatile DLSN lastCommittedPosition = null;

    public ZKSubscriptionStateStore(ZooKeeperClient zooKeeperClient, String zkPath) {
        this.zooKeeperClient = zooKeeperClient;
        this.zkPath = zkPath;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public CompletableFuture<DLSN> getLastCommitPosition() {
        DLSN dlsn = lastCommittedPositionUpdater.get(this);
        if (null != dlsn) {
            return FutureUtils.value(dlsn);
        }
        return this.getLastCommitPositionFromZK();
    }

    CompletableFuture<DLSN> getLastCommitPositionFromZK() {
        final CompletableFuture<DLSN> result = new CompletableFuture<DLSN>();
        try {
            logger.debug("Reading last commit position from path {}", (Object)this.zkPath);
            this.zooKeeperClient.get().getData(this.zkPath, false, new AsyncCallback.DataCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                    logger.debug("Read last commit position from path {}: rc = {}", (Object)ZKSubscriptionStateStore.this.zkPath, (Object)rc);
                    if (KeeperException.Code.NONODE.intValue() == rc) {
                        result.complete(DLSN.NonInclusiveLowerBound);
                    } else if (KeeperException.Code.OK.intValue() != rc) {
                        result.completeExceptionally(KeeperException.create(KeeperException.Code.get(rc), path));
                    } else {
                        try {
                            DLSN dlsn = DLSN.deserialize(new String(data, StandardCharsets.UTF_8));
                            result.complete(dlsn);
                        }
                        catch (Exception t) {
                            logger.warn("Invalid last commit position found from path {}", (Object)ZKSubscriptionStateStore.this.zkPath, (Object)t);
                            result.complete(DLSN.NonInclusiveLowerBound);
                        }
                    }
                }
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException zkce) {
            result.completeExceptionally(zkce);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            result.completeExceptionally(new DLInterruptedException("getLastCommitPosition was interrupted", (Throwable)ie));
        }
        return result;
    }

    @Override
    public CompletableFuture<Void> advanceCommitPosition(DLSN newPosition) {
        DLSN dlsn = lastCommittedPositionUpdater.get(this);
        if (null == dlsn || newPosition.compareTo(dlsn) > 0) {
            lastCommittedPositionUpdater.set(this, newPosition);
            return Utils.zkAsyncCreateFullPathOptimisticAndSetData(this.zooKeeperClient, this.zkPath, newPosition.serialize().getBytes(StandardCharsets.UTF_8), this.zooKeeperClient.getDefaultACL(), CreateMode.PERSISTENT);
        }
        return FutureUtils.Void();
    }
}

