/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog.lock;

import dlshade.org.apache.distributedlog.exceptions.DLInterruptedException;
import dlshade.org.apache.distributedlog.lock.LockTimeoutException;
import dlshade.org.apache.distributedlog.util.Utils;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockWaiter {
    private static final Logger logger = LoggerFactory.getLogger(LockWaiter.class);
    private final String lockId;
    private final String currentOwner;
    private final CompletableFuture<Boolean> acquireFuture;

    public LockWaiter(String lockId, String currentOwner, CompletableFuture<Boolean> acquireFuture) {
        this.lockId = lockId;
        this.currentOwner = currentOwner;
        this.acquireFuture = acquireFuture;
    }

    public String getId() {
        return this.lockId;
    }

    public String getCurrentOwner() {
        return this.currentOwner;
    }

    public CompletableFuture<Boolean> getAcquireFuture() {
        return this.acquireFuture;
    }

    public boolean waitForAcquireQuietly() {
        boolean success = false;
        try {
            success = Utils.ioResult(this.acquireFuture);
        }
        catch (DLInterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (LockTimeoutException lte) {
            logger.debug("Timeout on lock acquiring", (Throwable)lte);
        }
        catch (IOException e) {
            logger.error("Caught exception waiting for lock acquired", (Throwable)e);
        }
        return success;
    }
}

