/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog.lock;

import dlshade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import dlshade.org.apache.bookkeeper.common.util.OrderedScheduler;
import dlshade.org.apache.bookkeeper.stats.StatsLogger;
import dlshade.org.apache.distributedlog.ZooKeeperClient;
import dlshade.org.apache.distributedlog.exceptions.DLInterruptedException;
import dlshade.org.apache.distributedlog.lock.DistributedLockContext;
import dlshade.org.apache.distributedlog.lock.SessionLock;
import dlshade.org.apache.distributedlog.lock.SessionLockFactory;
import dlshade.org.apache.distributedlog.lock.ZKSessionLock;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ZKSessionLockFactory
implements SessionLockFactory {
    private final ZooKeeperClient zkc;
    private final String clientId;
    private final OrderedScheduler lockStateExecutor;
    private final long lockOpTimeout;
    private final int lockCreationRetries;
    private final long zkRetryBackoffMs;
    private final StatsLogger lockStatsLogger;

    public ZKSessionLockFactory(ZooKeeperClient zkc, String clientId, OrderedScheduler lockStateExecutor, int lockCreationRetries, long lockOpTimeout, long zkRetryBackoffMs, StatsLogger statsLogger) {
        this.zkc = zkc;
        this.clientId = clientId;
        this.lockStateExecutor = lockStateExecutor;
        this.lockCreationRetries = lockCreationRetries;
        this.lockOpTimeout = lockOpTimeout;
        this.zkRetryBackoffMs = zkRetryBackoffMs;
        this.lockStatsLogger = statsLogger.scope("lock");
    }

    @Override
    public CompletableFuture<SessionLock> createLock(String lockPath, DistributedLockContext context) {
        AtomicInteger numRetries = new AtomicInteger(this.lockCreationRetries);
        AtomicReference<Object> interruptedException = new AtomicReference<Object>(null);
        CompletableFuture<SessionLock> createPromise = FutureUtils.createFuture();
        createPromise.whenComplete((value, cause) -> {
            if (null != cause && cause instanceof CancellationException) {
                interruptedException.set(cause);
            }
        });
        this.createLock(lockPath, context, interruptedException, numRetries, createPromise, 0L);
        return createPromise;
    }

    void createLock(String lockPath, DistributedLockContext context, AtomicReference<Throwable> interruptedException, AtomicInteger numRetries, CompletableFuture<SessionLock> createPromise, long delayMs) {
        this.lockStateExecutor.scheduleOrdered(lockPath, () -> {
            if (null != interruptedException.get()) {
                createPromise.completeExceptionally((Throwable)interruptedException.get());
                return;
            }
            try {
                ZKSessionLock lock = new ZKSessionLock(this.zkc, lockPath, this.clientId, this.lockStateExecutor, this.lockOpTimeout, this.lockStatsLogger, context);
                createPromise.complete(lock);
            }
            catch (DLInterruptedException dlie) {
                createPromise.completeExceptionally(dlie);
                return;
            }
            catch (IOException e) {
                if (numRetries.getAndDecrement() < 0) {
                    createPromise.completeExceptionally(e);
                    return;
                }
                this.createLock(lockPath, context, interruptedException, numRetries, createPromise, this.zkRetryBackoffMs);
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }
}

