/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog.logsegment;

import dlshade.com.google.common.base.Ticker;
import dlshade.com.google.common.cache.Cache;
import dlshade.com.google.common.cache.CacheBuilder;
import dlshade.com.google.common.cache.RemovalListener;
import dlshade.com.google.common.cache.RemovalNotification;
import dlshade.org.apache.distributedlog.DistributedLogConfiguration;
import dlshade.org.apache.distributedlog.LogSegmentMetadata;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSegmentMetadataCache
implements RemovalListener<String, LogSegmentMetadata> {
    private static final Logger logger = LoggerFactory.getLogger(LogSegmentMetadataCache.class);
    private final Cache<String, LogSegmentMetadata> cache;
    private final boolean isCacheEnabled;

    public LogSegmentMetadataCache(DistributedLogConfiguration conf, Ticker ticker) {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(conf.getNumWorkerThreads()).initialCapacity(1024).expireAfterAccess(conf.getLogSegmentCacheTTLMs(), TimeUnit.MILLISECONDS).maximumSize(conf.getLogSegmentCacheMaxSize()).removalListener(this).ticker(ticker).recordStats().build();
        this.isCacheEnabled = conf.isLogSegmentCacheEnabled();
        logger.info("Log segment cache is enabled = {}", (Object)this.isCacheEnabled);
    }

    public void put(String path, LogSegmentMetadata segment) {
        if (this.isCacheEnabled) {
            this.cache.put(path, segment);
        }
    }

    public void invalidate(String path) {
        if (this.isCacheEnabled) {
            this.cache.invalidate(path);
        }
    }

    public LogSegmentMetadata get(String path) {
        return this.cache.getIfPresent(path);
    }

    @Override
    public void onRemoval(RemovalNotification<String, LogSegmentMetadata> notification) {
        if (notification.wasEvicted() && logger.isDebugEnabled()) {
            logger.debug("Log segment of {} was evicted.", notification.getKey());
        }
    }
}

