/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog.tools;

import dlshade.org.apache.bookkeeper.common.util.ReflectionUtils;
import dlshade.org.apache.commons.cli.BasicParser;
import dlshade.org.apache.commons.cli.CommandLine;
import dlshade.org.apache.commons.cli.HelpFormatter;
import dlshade.org.apache.commons.cli.Options;
import dlshade.org.apache.commons.cli.ParseException;
import java.util.Map;
import java.util.TreeMap;

public abstract class Tool {
    protected final Map<String, Command> commands = new TreeMap<String, Command>();

    protected Tool() {
        this.addCommand(new HelpCommand());
    }

    protected abstract String getName();

    protected void addCommand(Command command) {
        this.commands.put(command.getName(), command);
    }

    protected static void println(String msg) {
        System.out.println(msg);
    }

    protected void printToolUsage() {
        Tool.println("Usage: " + this.getName() + " <command>");
        Tool.println("");
        int maxKeyLength = 0;
        for (String string : this.commands.keySet()) {
            if (string.length() <= maxKeyLength) continue;
            maxKeyLength = string.length();
        }
        maxKeyLength += 2;
        for (Map.Entry entry : this.commands.entrySet()) {
            StringBuilder spacesBuilder = new StringBuilder();
            int numSpaces = maxKeyLength - ((String)entry.getKey()).length();
            for (int i = 0; i < numSpaces; ++i) {
                spacesBuilder.append(" ");
            }
            Tool.println("\t" + (String)entry.getKey() + spacesBuilder + ": " + ((Command)entry.getValue()).getDescription());
        }
        Tool.println("");
    }

    public int run(String[] args) throws Exception {
        if (args.length <= 0) {
            this.printToolUsage();
            return -1;
        }
        String cmdName = args[0];
        Command cmd = this.commands.get(cmdName);
        if (null == cmd) {
            System.err.println("ERROR: Unknown command " + cmdName);
            this.printToolUsage();
            return -1;
        }
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        return cmd.runCmd(newArgs);
    }

    public static void main(String[] args) {
        int rc = -1;
        if (args.length <= 0) {
            System.err.println("No tool to run.");
            System.err.println();
            System.err.println("Usage : Tool <tool_class_name> <options>");
            System.exit(-1);
        }
        String toolClass = args[0];
        try {
            Tool tool = ReflectionUtils.newInstance(toolClass, Tool.class);
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, newArgs.length);
            rc = tool.run(newArgs);
        }
        catch (Throwable t) {
            System.err.println("Fail to run tool " + toolClass + " : ");
            t.printStackTrace();
        }
        System.exit(rc);
    }

    public class HelpCommand
    implements Command {
        @Override
        public String getName() {
            return "help";
        }

        @Override
        public String getDescription() {
            return "describe the usage of this tool or its sub-commands.";
        }

        @Override
        public int runCmd(String[] args) throws Exception {
            if (args.length == 0) {
                Tool.this.printToolUsage();
                return -1;
            }
            String cmdName = args[0];
            Command command = Tool.this.commands.get(cmdName);
            if (null == command) {
                System.err.println("Unknown command " + cmdName);
                Tool.this.printToolUsage();
                return -1;
            }
            command.printUsage();
            Tool.println("");
            return 0;
        }

        @Override
        public void printUsage() {
            Tool.println(this.getName() + ": " + this.getDescription());
            Tool.println("");
            Tool.println("usage: " + this.getName() + " <command>");
        }
    }

    protected static abstract class OptsCommand
    implements Command {
        protected String cmdName;
        protected String description;

        protected abstract Options getOptions();

        protected String getUsage() {
            return this.cmdName + " [options]";
        }

        protected abstract int runCmd(CommandLine var1) throws Exception;

        protected OptsCommand(String name, String description) {
            this.cmdName = name;
            this.description = description;
        }

        @Override
        public String getName() {
            return this.cmdName;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int runCmd(String[] args) throws Exception {
            try {
                BasicParser parser = new BasicParser();
                CommandLine cmdline = parser.parse(this.getOptions(), args);
                return this.runCmd(cmdline);
            }
            catch (ParseException e) {
                this.printUsage();
                return -1;
            }
        }

        @Override
        public void printUsage() {
            HelpFormatter helpFormatter = new HelpFormatter();
            Tool.println(this.cmdName + ": " + this.getDescription());
            helpFormatter.printHelp(this.getUsage(), this.getOptions());
        }
    }

    protected static interface Command {
        public String getName();

        public String getDescription();

        public int runCmd(String[] var1) throws Exception;

        public void printUsage();
    }
}

