/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.distributedlog.util;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailpointUtils {
    private static final Logger logger = LoggerFactory.getLogger(FailpointUtils.class);
    public static final FailPointAction DEFAULT_ACTION = new AbstractFailPointAction(){

        @Override
        public boolean checkFailPoint() throws IOException {
            return true;
        }
    };
    public static final FailPointAction THROW_ACTION = new AbstractFailPointAction(){

        @Override
        public boolean checkFailPoint() throws IOException {
            throw new IOException("Throw ioexception for failure point");
        }
    };
    static ConcurrentHashMap<FailPointName, FailPointAction> failPointState = new ConcurrentHashMap();

    public static void setFailpoint(FailPointName failpoint, FailPointActions action) {
        FailPointAction fpAction = null;
        switch (action) {
            case FailPointAction_Default: {
                fpAction = DEFAULT_ACTION;
                break;
            }
            case FailPointAction_Throw: {
                fpAction = THROW_ACTION;
                break;
            }
        }
        FailpointUtils.setFailpoint(failpoint, fpAction);
    }

    public static void setFailpoint(FailPointName failpoint, FailPointAction action) {
        if (null != action) {
            failPointState.put(failpoint, action);
        }
    }

    public static void removeFailpoint(FailPointName failpoint) {
        failPointState.remove((Object)failpoint);
    }

    public static boolean checkFailPoint(FailPointName failPoint) throws IOException {
        FailPointAction action = failPointState.get((Object)failPoint);
        if (action == null) {
            return false;
        }
        try {
            return action.checkFailPoint();
        }
        catch (IOException ioe) {
            throw new IOException("Induced Exception at:" + (Object)((Object)failPoint), ioe);
        }
    }

    public static boolean checkFailPointNoThrow(FailPointName failPoint) {
        FailPointAction action = failPointState.get((Object)failPoint);
        if (action == null) {
            return false;
        }
        return action.checkFailPointNoThrow();
    }

    public static enum FailPointActions {
        FailPointAction_Default,
        FailPointAction_Throw;

    }

    public static abstract class AbstractFailPointAction
    implements FailPointAction {
        @Override
        public boolean checkFailPointNoThrow() {
            try {
                return this.checkFailPoint();
            }
            catch (IOException ex) {
                logger.error("failpoint action raised unexpected exception");
                return true;
            }
        }
    }

    public static interface FailPointAction {
        public boolean checkFailPoint() throws IOException;

        public boolean checkFailPointNoThrow();
    }

    public static enum FailPointName {
        FP_StartLogSegmentBeforeLedgerCreate,
        FP_StartLogSegmentAfterLedgerCreate,
        FP_StartLogSegmentAfterInProgressCreate,
        FP_StartLogSegmentOnAssignLogSegmentSequenceNumber,
        FP_FinalizeLedgerBeforeDelete,
        FP_TransmitBeforeAddEntry,
        FP_TransmitComplete,
        FP_WriteInternalLostLock,
        FP_TransmitFailGetBuffer,
        FP_LockUnlockCleanup,
        FP_LockTryCloseRaceCondition,
        FP_LockTryAcquire,
        FP_ZooKeeperConnectionLoss,
        FP_RecoverIncompleteLogSegments,
        FP_LogWriterIssuePending;

    }
}

