/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.http.protocol;

import dlshade.org.apache.http.HttpEntityEnclosingRequest;
import dlshade.org.apache.http.HttpException;
import dlshade.org.apache.http.HttpRequest;
import dlshade.org.apache.http.HttpRequestInterceptor;
import dlshade.org.apache.http.annotation.Contract;
import dlshade.org.apache.http.annotation.ThreadingBehavior;
import dlshade.org.apache.http.protocol.HttpContext;
import dlshade.org.apache.http.protocol.HttpDateGenerator;
import dlshade.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

