/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.http.protocol;

import dlshade.org.apache.http.HttpConnection;
import dlshade.org.apache.http.HttpException;
import dlshade.org.apache.http.HttpHost;
import dlshade.org.apache.http.HttpInetConnection;
import dlshade.org.apache.http.HttpRequest;
import dlshade.org.apache.http.HttpRequestInterceptor;
import dlshade.org.apache.http.HttpVersion;
import dlshade.org.apache.http.ProtocolException;
import dlshade.org.apache.http.ProtocolVersion;
import dlshade.org.apache.http.annotation.Contract;
import dlshade.org.apache.http.annotation.ThreadingBehavior;
import dlshade.org.apache.http.protocol.HttpContext;
import dlshade.org.apache.http.protocol.HttpCoreContext;
import dlshade.org.apache.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

