/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.zookeeper.cli;

import dlshade.org.apache.zookeeper.data.ACL;
import dlshade.org.apache.zookeeper.data.Id;
import java.util.ArrayList;
import java.util.List;

public class AclParser {
    public static List<ACL> parse(String aclString) {
        String[] acls = aclString.split(",");
        ArrayList<ACL> acl = new ArrayList<ACL>();
        for (String a : acls) {
            int firstColon = a.indexOf(58);
            int lastColon = a.lastIndexOf(58);
            if (firstColon == -1 || lastColon == -1 || firstColon == lastColon) {
                System.err.println(a + " does not have the form scheme:id:perm");
                continue;
            }
            ACL newAcl = new ACL();
            newAcl.setId(new Id(a.substring(0, firstColon), a.substring(firstColon + 1, lastColon)));
            newAcl.setPerms(AclParser.getPermFromString(a.substring(lastColon + 1)));
            acl.add(newAcl);
        }
        return acl;
    }

    private static int getPermFromString(String permString) {
        int perm = 0;
        block7: for (int i = 0; i < permString.length(); ++i) {
            switch (permString.charAt(i)) {
                case 'r': {
                    perm |= 1;
                    continue block7;
                }
                case 'w': {
                    perm |= 2;
                    continue block7;
                }
                case 'c': {
                    perm |= 4;
                    continue block7;
                }
                case 'd': {
                    perm |= 8;
                    continue block7;
                }
                case 'a': {
                    perm |= 0x10;
                    continue block7;
                }
                default: {
                    System.err.println("Unknown perm type: " + permString.charAt(i));
                }
            }
        }
        return perm;
    }
}

