/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.zookeeper.cli;

import dlshade.org.apache.commons.cli.CommandLine;
import dlshade.org.apache.commons.cli.DefaultParser;
import dlshade.org.apache.commons.cli.Options;
import dlshade.org.apache.commons.cli.ParseException;
import dlshade.org.apache.zookeeper.KeeperException;
import dlshade.org.apache.zookeeper.cli.CliCommand;
import dlshade.org.apache.zookeeper.cli.CliException;
import dlshade.org.apache.zookeeper.cli.CliParseException;
import dlshade.org.apache.zookeeper.cli.CliWrapperException;
import dlshade.org.apache.zookeeper.cli.MalformedPathException;

public class DeleteCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public DeleteCommand() {
        super("delete", "[-v version] path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        DefaultParser parser = new DefaultParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        this.retainCompatibility(cmdArgs);
        return this;
    }

    private void retainCompatibility(String[] cmdArgs) throws CliParseException {
        if (this.args.length > 2) {
            this.err.println("'delete path [version]' has been deprecated. Please use 'delete [-v version] path' instead.");
            DefaultParser parser = new DefaultParser();
            try {
                this.cl = parser.parse(options, cmdArgs);
            }
            catch (ParseException ex) {
                throw new CliParseException(ex);
            }
            this.args = this.cl.getArgs();
        }
    }

    @Override
    public boolean exec() throws CliException {
        String path = this.args[1];
        int version = this.cl.hasOption("v") ? Integer.parseInt(this.cl.getOptionValue("v")) : -1;
        try {
            this.zk.delete(path, version);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }

    static {
        options.addOption("v", true, "version");
    }
}

