/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.zookeeper.common;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecretUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecretUtils.class);

    private SecretUtils() {
    }

    public static char[] readSecret(String pathToFile) {
        LOG.info("Reading secret from {}", (Object)pathToFile);
        try {
            String secretValue = new String(Files.readAllBytes(Paths.get(pathToFile, new String[0])), StandardCharsets.UTF_8);
            if (secretValue.endsWith(System.lineSeparator())) {
                return secretValue.substring(0, secretValue.length() - System.lineSeparator().length()).toCharArray();
            }
            return secretValue.toCharArray();
        }
        catch (Throwable e) {
            LOG.error("Exception occurred when reading secret from file {}", (Object)pathToFile, (Object)e);
            throw new IllegalStateException("Exception occurred when reading secret from file " + pathToFile, e);
        }
    }
}

