/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.zookeeper.server.embedded;

import dlshade.org.apache.zookeeper.server.DatadirCleanupManager;
import dlshade.org.apache.zookeeper.server.ExitCode;
import dlshade.org.apache.zookeeper.server.ServerConfig;
import dlshade.org.apache.zookeeper.server.ZooKeeperServerMain;
import dlshade.org.apache.zookeeper.server.embedded.ExitHandler;
import dlshade.org.apache.zookeeper.server.embedded.ZooKeeperServerEmbedded;
import dlshade.org.apache.zookeeper.server.quorum.QuorumPeer;
import dlshade.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import dlshade.org.apache.zookeeper.server.quorum.QuorumPeerMain;
import dlshade.org.apache.zookeeper.util.ServiceUtils;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZooKeeperServerEmbeddedImpl
implements ZooKeeperServerEmbedded {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperServerEmbeddedImpl.class);
    private final QuorumPeerConfig config;
    private QuorumPeerMain maincluster;
    private ZooKeeperServerMain mainsingle;
    private Thread thread;
    private DatadirCleanupManager purgeMgr;
    private final ExitHandler exitHandler;
    private volatile boolean stopping;

    ZooKeeperServerEmbeddedImpl(Properties p, Path baseDir, ExitHandler exitHandler) throws Exception {
        if (!p.containsKey("dataDir")) {
            p.put("dataDir", baseDir.resolve("data").toAbsolutePath().toString());
        }
        Path configFile = Files.createTempFile(baseDir, "zookeeper.configuration", ".properties", new FileAttribute[0]);
        try (OutputStream oo = Files.newOutputStream(configFile, new OpenOption[0]);){
            p.store(oo, "Automatically generated at every-boot");
        }
        this.exitHandler = exitHandler;
        LOG.info("Current configuration is at {}", (Object)configFile.toAbsolutePath());
        this.config = new QuorumPeerConfig();
        this.config.parse(configFile.toAbsolutePath().toString());
        LOG.info("ServerID:" + this.config.getServerId());
        LOG.info("DataDir:" + this.config.getDataDir());
        LOG.info("Servers:" + this.config.getServers());
        LOG.info("ElectionPort:" + this.config.getElectionPort());
        LOG.info("SyncLimit:" + this.config.getSyncLimit());
        LOG.info("PeerType:" + (Object)((Object)this.config.getPeerType()));
        LOG.info("Distributed:" + this.config.isDistributed());
        LOG.info("SyncEnabled:" + this.config.getSyncEnabled());
        LOG.info("MetricsProviderClassName:" + this.config.getMetricsProviderClassName());
        for (Map.Entry<Long, QuorumPeer.QuorumServer> server : this.config.getServers().entrySet()) {
            LOG.info("Server: " + server.getKey() + " -> addr " + server.getValue().addr + " elect " + server.getValue().electionAddr + " id=" + server.getValue().id + " type " + (Object)((Object)server.getValue().type));
        }
    }

    @Override
    public void start() throws Exception {
        this.start(Integer.MAX_VALUE);
    }

    @Override
    public void start(long startupTimeout) throws Exception {
        switch (this.exitHandler) {
            case EXIT: {
                ServiceUtils.setSystemExitProcedure(ServiceUtils.SYSTEM_EXIT);
                break;
            }
            case LOG_ONLY: {
                ServiceUtils.setSystemExitProcedure(ServiceUtils.LOG_ONLY);
                break;
            }
            default: {
                ServiceUtils.setSystemExitProcedure(ServiceUtils.SYSTEM_EXIT);
            }
        }
        final CompletableFuture started = new CompletableFuture();
        if (this.config.getServers().size() > 1 || this.config.isDistributed()) {
            LOG.info("Running ZK Server in single Quorum MODE");
            this.maincluster = new QuorumPeerMain(){

                @Override
                protected QuorumPeer getQuorumPeer() throws SaslException {
                    return new QuorumPeer(){

                        @Override
                        public void start() {
                            super.start();
                            LOG.info("ZK Server {} started", (Object)this);
                            started.complete(null);
                        }
                    };
                }
            };
            this.purgeMgr = new DatadirCleanupManager(this.config.getDataDir(), this.config.getDataLogDir(), this.config.getSnapRetainCount(), this.config.getPurgeInterval());
            this.purgeMgr.start();
            this.thread = new Thread("zkservermainrunner"){

                @Override
                public void run() {
                    block3: {
                        try {
                            ZooKeeperServerEmbeddedImpl.this.maincluster.runFromConfig(ZooKeeperServerEmbeddedImpl.this.config);
                            ZooKeeperServerEmbeddedImpl.this.maincluster.close();
                            LOG.info("ZK server died. Requsting stop on JVM");
                            if (!ZooKeeperServerEmbeddedImpl.this.stopping) {
                                ServiceUtils.requestSystemExit(ExitCode.EXECUTION_FINISHED.getValue());
                            }
                        }
                        catch (Throwable t) {
                            LOG.error("error during server lifecycle", t);
                            ZooKeeperServerEmbeddedImpl.this.maincluster.close();
                            if (ZooKeeperServerEmbeddedImpl.this.stopping) break block3;
                            ServiceUtils.requestSystemExit(ExitCode.INVALID_INVOCATION.getValue());
                        }
                    }
                }
            };
            this.thread.start();
        } else {
            LOG.info("Running ZK Server in single STANDALONE MODE");
            this.mainsingle = new ZooKeeperServerMain(){

                @Override
                public void serverStarted() {
                    LOG.info("ZK Server started");
                    started.complete(null);
                }
            };
            this.purgeMgr = new DatadirCleanupManager(this.config.getDataDir(), this.config.getDataLogDir(), this.config.getSnapRetainCount(), this.config.getPurgeInterval());
            this.purgeMgr.start();
            this.thread = new Thread("zkservermainrunner"){

                @Override
                public void run() {
                    block3: {
                        try {
                            ServerConfig cc = new ServerConfig();
                            cc.readFrom(ZooKeeperServerEmbeddedImpl.this.config);
                            LOG.info("ZK server starting");
                            ZooKeeperServerEmbeddedImpl.this.mainsingle.runFromConfig(cc);
                            LOG.info("ZK server died. Requesting stop on JVM");
                            if (!ZooKeeperServerEmbeddedImpl.this.stopping) {
                                ServiceUtils.requestSystemExit(ExitCode.EXECUTION_FINISHED.getValue());
                            }
                        }
                        catch (Throwable t) {
                            LOG.error("error during server lifecycle", t);
                            ZooKeeperServerEmbeddedImpl.this.mainsingle.close();
                            if (ZooKeeperServerEmbeddedImpl.this.stopping) break block3;
                            ServiceUtils.requestSystemExit(ExitCode.INVALID_INVOCATION.getValue());
                        }
                    }
                }
            };
            this.thread.start();
        }
        try {
            started.get(startupTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException err) {
            LOG.info("Startup timed out, trying to close");
            this.close();
            throw err;
        }
    }

    @Override
    public String getConnectionString() {
        if (this.config.getClientPortAddress() != null) {
            String raw = this.config.getClientPortAddress().getHostString() + ":" + this.config.getClientPortAddress().getPort();
            return raw.replace("0.0.0.0", "localhost");
        }
        throw new IllegalStateException("No client address is configured");
    }

    @Override
    public String getSecureConnectionString() {
        if (this.config.getSecureClientPortAddress() != null) {
            String raw = this.config.getSecureClientPortAddress().getHostString() + ":" + this.config.getSecureClientPortAddress().getPort();
            return raw.replace("0.0.0.0", "localhost");
        }
        throw new IllegalStateException("No client address is configured");
    }

    @Override
    public void close() {
        LOG.info("Stopping ZK Server");
        this.stopping = true;
        if (this.mainsingle != null) {
            this.mainsingle.close();
        }
        if (this.maincluster != null) {
            this.maincluster.close();
        }
    }
}

