/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.apache.zookeeper.server.metric;

import dlshade.org.apache.zookeeper.metrics.SummarySet;
import dlshade.org.apache.zookeeper.server.metric.AvgMinMaxCounter;
import dlshade.org.apache.zookeeper.server.metric.Metric;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AvgMinMaxCounterSet
extends Metric
implements SummarySet {
    private final String name;
    private ConcurrentHashMap<String, AvgMinMaxCounter> counters = new ConcurrentHashMap();

    public AvgMinMaxCounterSet(String name) {
        this.name = name;
    }

    private AvgMinMaxCounter getCounterForKey(String key) {
        return this.counters.computeIfAbsent(key, k -> new AvgMinMaxCounter(k + "_" + this.name));
    }

    public void addDataPoint(String key, long value) {
        this.getCounterForKey(key).addDataPoint(value);
    }

    public void resetMax() {
        for (Map.Entry<String, AvgMinMaxCounter> entry : this.counters.entrySet()) {
            entry.getValue().resetMax();
        }
    }

    @Override
    public void reset() {
        for (Map.Entry<String, AvgMinMaxCounter> entry : this.counters.entrySet()) {
            entry.getValue().reset();
        }
    }

    @Override
    public void add(String key, long value) {
        this.addDataPoint(key, value);
    }

    @Override
    public Map<String, Object> values() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, AvgMinMaxCounter> entry : this.counters.entrySet()) {
            m.putAll(entry.getValue().values());
        }
        return m;
    }
}

