/*
 * Decompiled with CFR 0.152.
 */
package dlshade.org.rocksdb;

import dlshade.org.rocksdb.util.Environment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class NativeLibraryLoader {
    private static final NativeLibraryLoader instance = new NativeLibraryLoader();
    private static boolean initialized = false;
    private static final String sharedLibraryName = Environment.getSharedLibraryName("rocksdb");
    private static final String jniLibraryName = Environment.getJniLibraryName("rocksdb");
    private static final String fallbackJniLibraryName = Environment.getFallbackJniLibraryName("rocksdb");
    private static final String jniLibraryFileName = Environment.getJniLibraryFileName("rocksdb");
    private static final String fallbackJniLibraryFileName = Environment.getFallbackJniLibraryFileName("rocksdb");
    private static final String tempFilePrefix = "librocksdbjni";
    private static final String tempFileSuffix = Environment.getJniLibraryExtension();

    public static NativeLibraryLoader getInstance() {
        return instance;
    }

    public synchronized void loadLibrary(String string) throws IOException {
        try {
            System.loadLibrary(sharedLibraryName);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                System.loadLibrary(jniLibraryName);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                if (fallbackJniLibraryName != null) {
                    try {
                        System.loadLibrary(fallbackJniLibraryName);
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError3) {
                        // empty catch block
                    }
                }
                this.loadLibraryFromJar(string);
                return;
            }
        }
    }

    void loadLibraryFromJar(String string) throws IOException {
        if (!initialized) {
            System.load(this.loadLibraryFromJarToTemp(string).getAbsolutePath());
            initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File loadLibraryFromJarToTemp(String string) throws IOException {
        try (InputStream inputStream = null;){
            File file;
            File file2;
            String string2 = jniLibraryFileName;
            inputStream = this.getClass().getClassLoader().getResourceAsStream(string2);
            if (inputStream == null) {
                if (fallbackJniLibraryFileName == null) {
                    throw new RuntimeException(string2 + " was not found inside JAR.");
                }
                string2 = fallbackJniLibraryFileName;
                inputStream = this.getClass().getClassLoader().getResourceAsStream(string2);
                if (inputStream == null) {
                    throw new RuntimeException(string2 + " was not found inside JAR.");
                }
            }
            if (string == null || string.isEmpty()) {
                file2 = File.createTempFile(tempFilePrefix, tempFileSuffix);
            } else {
                file = new File(string);
                if (!file.exists()) {
                    throw new RuntimeException("Directory: " + file.getAbsolutePath() + " does not exist!");
                }
                file2 = new File(file, string2);
                if (file2.exists() && !file2.delete()) {
                    throw new RuntimeException("File: " + file2.getAbsolutePath() + " already exists and cannot be removed.");
                }
                if (!file2.createNewFile()) {
                    throw new RuntimeException("File: " + file2.getAbsolutePath() + " could not be created.");
                }
            }
            if (!file2.exists()) {
                throw new RuntimeException("File " + file2.getAbsolutePath() + " does not exist.");
            }
            file2.deleteOnExit();
            Files.copy(inputStream, file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
            file = file2;
            return file;
        }
    }

    private NativeLibraryLoader() {
    }
}

