/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.broker.service.schema.exceptions.InvalidSchemaDataException;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.internal.DefaultImplementation;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Charsets;
import org.apache.pulsar.shade.javax.ws.rs.container.AsyncResponse;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.commons.lang.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.DeleteSchemaResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.GetAllVersionsSchemaResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.GetSchemaResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.IsCompatibilityResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.LongSchemaVersionResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.PostSchemaPayload;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.PostSchemaResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.LongSchemaVersion;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemasResourceBase
extends AdminResource {
    private final Clock clock;
    private static final Logger log = LoggerFactory.getLogger(SchemasResourceBase.class);

    public SchemasResourceBase() {
        this(Clock.systemUTC());
    }

    @VisibleForTesting
    public SchemasResourceBase(Clock clock) {
        this.clock = clock;
    }

    private static long getLongSchemaVersion(SchemaVersion schemaVersion) {
        if (schemaVersion instanceof LongSchemaVersion) {
            return ((LongSchemaVersion)schemaVersion).getVersion();
        }
        return -1L;
    }

    private String getSchemaId() {
        if (this.topicName.isPartitioned()) {
            return TopicName.get(this.topicName.getPartitionedTopicName()).getSchemaName();
        }
        return this.topicName.getSchemaName();
    }

    public void getSchema(boolean authoritative, AsyncResponse response) {
        this.validateOwnershipAndOperation(authoritative, TopicOperation.GET_METADATA);
        String schemaId = this.getSchemaId();
        this.pulsar().getSchemaRegistryService().getSchema(schemaId).handle((schema, error) -> {
            SchemasResourceBase.handleGetSchemaResponse(response, schema, error);
            return null;
        });
    }

    public void getSchema(boolean authoritative, String version, AsyncResponse response) {
        this.validateOwnershipAndOperation(authoritative, TopicOperation.GET_METADATA);
        String schemaId = this.getSchemaId();
        ByteBuffer bbVersion = ByteBuffer.allocate(8);
        bbVersion.putLong(Long.parseLong(version));
        SchemaVersion v = this.pulsar().getSchemaRegistryService().versionFromBytes(bbVersion.array());
        this.pulsar().getSchemaRegistryService().getSchema(schemaId, v).handle((schema, error) -> {
            SchemasResourceBase.handleGetSchemaResponse(response, schema, error);
            return null;
        });
    }

    public void getAllSchemas(boolean authoritative, AsyncResponse response) {
        this.validateOwnershipAndOperation(authoritative, TopicOperation.GET_METADATA);
        String schemaId = this.getSchemaId();
        this.pulsar().getSchemaRegistryService().trimDeletedSchemaAndGetList(schemaId).handle((schema, error) -> {
            SchemasResourceBase.handleGetAllSchemasResponse(response, schema, error);
            return null;
        });
    }

    public void deleteSchema(boolean authoritative, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        String schemaId = this.getSchemaId();
        this.pulsar().getSchemaRegistryService().deleteSchema(schemaId, StringUtils.defaultIfEmpty(this.clientAppId(), "")).handle((version, error) -> {
            if (Objects.isNull(error)) {
                response.resume(Response.ok().entity(DeleteSchemaResponse.builder().version(SchemasResourceBase.getLongSchemaVersion(version)).build()).build());
            } else {
                log.error("[{}] Failed to delete schema for topic {}", new Object[]{this.clientAppId(), this.topicName, error});
                response.resume(new RestException((Throwable)error));
            }
            return null;
        });
    }

    public void postSchema(PostSchemaPayload payload, boolean authoritative, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        ((CompletableFuture)this.getSchemaCompatibilityStrategyAsync().thenAccept(schemaCompatibilityStrategy -> {
            byte[] data;
            if (SchemaType.KEY_VALUE.name().equals(payload.getType())) {
                try {
                    data = DefaultImplementation.getDefaultImplementation().convertKeyValueDataStringToSchemaInfoSchema(payload.getSchema().getBytes(Charsets.UTF_8));
                }
                catch (IOException conversionError) {
                    log.error("[{}] Failed to post schema for topic {}", new Object[]{this.clientAppId(), this.topicName, conversionError});
                    response.resume(new RestException(conversionError));
                    return;
                }
            } else {
                data = payload.getSchema().getBytes(Charsets.UTF_8);
            }
            ((CompletableFuture)this.pulsar().getSchemaRegistryService().putSchemaIfAbsent(this.getSchemaId(), SchemaData.builder().data(data).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf(payload.getType())).user(StringUtils.defaultIfEmpty(this.clientAppId(), "")).props(payload.getProperties()).build(), (SchemaCompatibilityStrategy)((Object)schemaCompatibilityStrategy)).thenAccept(version -> response.resume(Response.accepted().entity(PostSchemaResponse.builder().version((SchemaVersion)version).build()).build()))).exceptionally(error -> {
                if (error.getCause() instanceof IncompatibleSchemaException) {
                    response.resume(Response.status(Response.Status.CONFLICT.getStatusCode(), error.getCause().getMessage()).build());
                } else if (error instanceof InvalidSchemaDataException) {
                    response.resume(Response.status(422, error.getMessage()).build());
                } else {
                    log.error("[{}] Failed to post schema for topic {}", new Object[]{this.clientAppId(), this.topicName, error});
                    response.resume(new RestException((Throwable)error));
                }
                return null;
            });
        })).exceptionally(error -> {
            if (error.getCause() instanceof RestException) {
                response.resume(Response.status(((RestException)error.getCause()).getResponse().getStatus(), error.getMessage()).build());
            } else {
                log.error("[{}] Failed to post schema for topic {}", new Object[]{this.clientAppId(), this.topicName, error});
                response.resume(new RestException((Throwable)error));
            }
            return null;
        });
    }

    public void testCompatibility(PostSchemaPayload payload, boolean authoritative, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        String schemaId = this.getSchemaId();
        ((CompletableFuture)this.getSchemaCompatibilityStrategyAsync().thenCompose(schemaCompatibilityStrategy -> this.pulsar().getSchemaRegistryService().isCompatible(schemaId, SchemaData.builder().data(payload.getSchema().getBytes(Charsets.UTF_8)).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf(payload.getType())).user(StringUtils.defaultIfEmpty(this.clientAppId(), "")).props(payload.getProperties()).build(), (SchemaCompatibilityStrategy)((Object)schemaCompatibilityStrategy)).thenAccept(isCompatible -> response.resume(Response.accepted().entity(IsCompatibilityResponse.builder().isCompatibility((boolean)isCompatible).schemaCompatibilityStrategy(schemaCompatibilityStrategy.name()).build()).build())))).exceptionally(error -> {
            response.resume(new RestException((Throwable)error));
            return null;
        });
    }

    public void getVersionBySchema(PostSchemaPayload payload, boolean authoritative, AsyncResponse response) {
        this.validateOwnershipAndOperation(authoritative, TopicOperation.GET_METADATA);
        String schemaId = this.getSchemaId();
        ((CompletableFuture)this.pulsar().getSchemaRegistryService().findSchemaVersion(schemaId, SchemaData.builder().data(payload.getSchema().getBytes(Charsets.UTF_8)).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf(payload.getType())).user(StringUtils.defaultIfEmpty(this.clientAppId(), "")).props(payload.getProperties()).build()).thenAccept(version -> response.resume(Response.accepted().entity(LongSchemaVersionResponse.builder().version((Long)version).build()).build()))).exceptionally(error -> {
            log.error("[{}] Failed to get version by schema for topic {}", new Object[]{this.clientAppId(), this.topicName, error});
            response.resume(new RestException((Throwable)error));
            return null;
        });
    }

    @Override
    protected String domain() {
        return "persistent";
    }

    private static GetSchemaResponse convertSchemaAndMetadataToGetSchemaResponse(SchemaRegistry.SchemaAndMetadata schemaAndMetadata) {
        try {
            String schemaData = schemaAndMetadata.schema.getType() == SchemaType.KEY_VALUE ? DefaultImplementation.getDefaultImplementation().convertKeyValueSchemaInfoDataToString(DefaultImplementation.getDefaultImplementation().decodeKeyValueSchemaInfo(schemaAndMetadata.schema.toSchemaInfo())) : new String(schemaAndMetadata.schema.getData(), StandardCharsets.UTF_8);
            return GetSchemaResponse.builder().version(SchemasResourceBase.getLongSchemaVersion(schemaAndMetadata.version)).type(schemaAndMetadata.schema.getType()).timestamp(schemaAndMetadata.schema.getTimestamp()).data(schemaData).properties(schemaAndMetadata.schema.getProps()).build();
        }
        catch (IOException conversionError) {
            throw new RuntimeException(conversionError);
        }
    }

    private static void handleGetSchemaResponse(AsyncResponse response, SchemaRegistry.SchemaAndMetadata schema, Throwable error) {
        if (Objects.isNull(error)) {
            if (Objects.isNull(schema)) {
                response.resume(Response.status(Response.Status.NOT_FOUND.getStatusCode(), "Schema not found").build());
            } else if (schema.schema.isDeleted()) {
                response.resume(Response.status(Response.Status.NOT_FOUND.getStatusCode(), "Schema is deleted").build());
            } else {
                response.resume(Response.ok().encoding("application/json").entity(SchemasResourceBase.convertSchemaAndMetadataToGetSchemaResponse(schema)).build());
            }
        } else {
            log.error("Failed to get schema", error);
            response.resume(new RestException(error));
        }
    }

    private static void handleGetAllSchemasResponse(AsyncResponse response, List<SchemaRegistry.SchemaAndMetadata> schemas, Throwable error) {
        if (Objects.isNull(error)) {
            if (Objects.isNull(schemas)) {
                response.resume(Response.status(Response.Status.NOT_FOUND.getStatusCode(), "Schemas not found").build());
            } else {
                response.resume(Response.ok().encoding("application/json").entity(GetAllVersionsSchemaResponse.builder().getSchemaResponses(schemas.stream().map(SchemasResourceBase::convertSchemaAndMetadataToGetSchemaResponse).collect(Collectors.toList())).build()).build());
            }
        } else {
            log.error("Failed to get all schemas", error);
            response.resume(new RestException(error));
        }
    }

    private void validateDestinationAndAdminOperation(boolean authoritative) {
        try {
            this.validateAdminAccessForTenant(this.topicName.getTenant());
            this.validateTopicOwnership(this.topicName, authoritative);
        }
        catch (RestException e) {
            if (e.getResponse().getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new RestException(Response.Status.UNAUTHORIZED, e.getMessage());
            }
            throw e;
        }
    }

    private void validateOwnershipAndOperation(boolean authoritative, TopicOperation operation) {
        try {
            this.validateTopicOwnership(this.topicName, authoritative);
            this.validateTopicOperation(this.topicName, operation);
        }
        catch (RestException e) {
            if (e.getResponse().getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new RestException(Response.Status.UNAUTHORIZED, e.getMessage());
            }
            throw e;
        }
    }
}

