/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resourcegroup;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.resourcegroup.ResourceGroup;
import org.apache.pulsar.broker.resourcegroup.ResourceGroupConfigListener;
import org.apache.pulsar.broker.resourcegroup.ResourceQuotaCalculator;
import org.apache.pulsar.broker.resourcegroup.ResourceQuotaCalculatorImpl;
import org.apache.pulsar.broker.resourcegroup.ResourceUsageConsumer;
import org.apache.pulsar.broker.resourcegroup.ResourceUsagePublisher;
import org.apache.pulsar.broker.resourcegroup.ResourceUsageTopicTransportManager;
import org.apache.pulsar.broker.resourcegroup.ResourceUsageTransportManager;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.io.prometheus.client.Counter;
import org.apache.pulsar.shade.io.prometheus.client.Summary;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.stats.TopicStatsImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.Runnables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceGroupService
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ResourceGroupService.class);
    private final PulsarService pulsar;
    protected final ResourceQuotaCalculator quotaCalculator;
    private ResourceUsageTransportManager resourceUsageTransportManagerMgr;
    private final ResourceGroupConfigListener rgConfigListener;
    private ConcurrentHashMap<String, ResourceGroup> resourceGroupsMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ResourceGroup> tenantToRGsMap = new ConcurrentHashMap();
    private ConcurrentHashMap<NamespaceName, ResourceGroup> namespaceToRGsMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ResourceGroup.BytesAndMessagesCount> topicProduceStats = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ResourceGroup.BytesAndMessagesCount> topicConsumeStats = new ConcurrentHashMap();
    private ScheduledFuture<?> aggregateLocalUsagePeriodicTask;
    private long aggregateLocalUsagePeriodInSeconds;
    private ScheduledFuture<?> calculateQuotaPeriodicTask;
    private long resourceUsagePublishPeriodInSeconds;
    private TimeUnit timeUnitScale;
    protected static final int MaxUsageReportSuppressRounds = 5;
    protected static long maxIntervalForSuppressingReportsMSecs;
    protected static final float UsageReportSuppressionTolerancePercentage = 5.0f;
    private static final String[] resourceGroupLabel;
    private static final String[] resourceGroupMonitoringclassLabels;
    private static final Counter rgCalculatedQuotaBytes;
    private static final Counter rgCalculatedQuotaMessages;
    private static final Counter rgLocalUsageBytes;
    private static final Counter rgLocalUsageMessages;
    private static final Counter rgUpdates;
    private static final Counter rgTenantRegisters;
    private static final Counter rgTenantUnRegisters;
    private static final Counter rgNamespaceRegisters;
    private static final Counter rgNamespaceUnRegisters;
    private static final Summary rgUsageAggregationLatency;
    private static final Summary rgQuotaCalculationLatency;

    public ResourceGroupService(PulsarService pulsar) {
        this.pulsar = pulsar;
        this.timeUnitScale = TimeUnit.SECONDS;
        this.quotaCalculator = new ResourceQuotaCalculatorImpl();
        this.resourceUsageTransportManagerMgr = pulsar.getResourceUsageTransportManager();
        this.rgConfigListener = new ResourceGroupConfigListener(this, pulsar);
        this.initialize();
    }

    public ResourceGroupService(PulsarService pulsar, TimeUnit timescale, ResourceUsageTopicTransportManager transportMgr, ResourceQuotaCalculator quotaCalc) {
        this.pulsar = pulsar;
        this.timeUnitScale = timescale;
        this.resourceUsageTransportManagerMgr = transportMgr;
        this.quotaCalculator = quotaCalc;
        this.rgConfigListener = new ResourceGroupConfigListener(this, pulsar);
        this.initialize();
    }

    public void resourceGroupCreate(String rgName, org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ResourceGroup rgConfig) throws PulsarAdminException {
        this.checkRGCreateParams(rgName, rgConfig);
        ResourceGroup rg = new ResourceGroup(this, rgName, rgConfig);
        this.resourceGroupsMap.put(rgName, rg);
    }

    public void resourceGroupCreate(String rgName, org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ResourceGroup rgConfig, ResourceUsagePublisher rgPublisher, ResourceUsageConsumer rgConsumer) throws PulsarAdminException {
        this.checkRGCreateParams(rgName, rgConfig);
        ResourceGroup rg = new ResourceGroup(this, rgName, rgConfig, rgPublisher, rgConsumer);
        this.resourceGroupsMap.put(rgName, rg);
    }

    public ResourceGroup resourceGroupGet(String resourceGroupName) {
        ResourceGroup retrievedRG = this.getResourceGroupInternal(resourceGroupName);
        if (retrievedRG == null) {
            return null;
        }
        return new ResourceGroup(retrievedRG);
    }

    public void resourceGroupUpdate(String rgName, org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ResourceGroup rgConfig) throws PulsarAdminException {
        if (rgConfig == null) {
            throw new IllegalArgumentException("ResourceGroupUpdate: Invalid null ResourceGroup config");
        }
        ResourceGroup rg = this.getResourceGroupInternal(rgName);
        if (rg == null) {
            throw new PulsarAdminException("Resource group does not exist: " + rgName);
        }
        rg.updateResourceGroup(rgConfig);
        ((Counter.Child)rgUpdates.labels(rgName)).inc();
    }

    public Set<String> resourceGroupGetAll() {
        return this.resourceGroupsMap.keySet();
    }

    public void resourceGroupDelete(String name) throws PulsarAdminException {
        long nsRefCount;
        ResourceGroup rg = this.getResourceGroupInternal(name);
        if (rg == null) {
            throw new PulsarAdminException("Resource group does not exist: " + name);
        }
        long tenantRefCount = rg.getResourceGroupNumOfTenantRefs();
        if (tenantRefCount + (nsRefCount = rg.getResourceGroupNumOfNSRefs()) > 0L) {
            String errMesg = "Resource group " + name + " still has " + tenantRefCount + " tenant refs";
            errMesg = errMesg + " and " + nsRefCount + " namespace refs on it";
            throw new PulsarAdminException(errMesg);
        }
        rg.resourceGroupPublishLimiter.close();
        rg.resourceGroupPublishLimiter = null;
        this.resourceGroupsMap.remove(name);
    }

    protected long getNumResourceGroups() {
        return this.resourceGroupsMap.mappingCount();
    }

    public void registerTenant(String resourceGroupName, String tenantName) throws PulsarAdminException {
        ResourceGroup rg = this.checkResourceGroupExists(resourceGroupName);
        ResourceGroup oldRG = this.tenantToRGsMap.get(tenantName);
        if (oldRG != null) {
            String errMesg = "Tenant " + tenantName + " already references a resource group: " + oldRG.getID();
            throw new PulsarAdminException(errMesg);
        }
        ResourceGroupOpStatus status = rg.registerUsage(tenantName, ResourceGroup.ResourceGroupRefTypes.Tenants, true, this.resourceUsageTransportManagerMgr);
        if (status == ResourceGroupOpStatus.Exists) {
            String errMesg = "Tenant " + tenantName + " already references the resource group " + resourceGroupName;
            errMesg = errMesg + "; this is unexpected";
            throw new PulsarAdminException(errMesg);
        }
        this.tenantToRGsMap.put(tenantName, rg);
        ((Counter.Child)rgTenantRegisters.labels(resourceGroupName)).inc();
    }

    public void unRegisterTenant(String resourceGroupName, String tenantName) throws PulsarAdminException {
        ResourceGroup rg = this.checkResourceGroupExists(resourceGroupName);
        ResourceGroupOpStatus status = rg.registerUsage(tenantName, ResourceGroup.ResourceGroupRefTypes.Tenants, false, this.resourceUsageTransportManagerMgr);
        if (status == ResourceGroupOpStatus.DoesNotExist) {
            String errMesg = "Tenant " + tenantName + " does not yet reference resource group " + resourceGroupName;
            throw new PulsarAdminException(errMesg);
        }
        this.tenantToRGsMap.remove(tenantName, rg);
        ((Counter.Child)rgTenantUnRegisters.labels(resourceGroupName)).inc();
    }

    public void registerNameSpace(String resourceGroupName, NamespaceName fqNamespaceName) throws PulsarAdminException {
        ResourceGroup rg = this.checkResourceGroupExists(resourceGroupName);
        ResourceGroup oldRG = this.namespaceToRGsMap.get(fqNamespaceName);
        if (oldRG != null) {
            String errMesg = "Namespace " + fqNamespaceName + " already references a resource group: " + oldRG.getID();
            throw new PulsarAdminException(errMesg);
        }
        ResourceGroupOpStatus status = rg.registerUsage(fqNamespaceName.toString(), ResourceGroup.ResourceGroupRefTypes.Namespaces, true, this.resourceUsageTransportManagerMgr);
        if (status == ResourceGroupOpStatus.Exists) {
            String errMesg = String.format("Namespace %s already references the target resource group %s", fqNamespaceName, resourceGroupName);
            throw new PulsarAdminException(errMesg);
        }
        this.namespaceToRGsMap.put(fqNamespaceName, rg);
        ((Counter.Child)rgNamespaceRegisters.labels(resourceGroupName)).inc();
    }

    public void unRegisterNameSpace(String resourceGroupName, NamespaceName fqNamespaceName) throws PulsarAdminException {
        ResourceGroup rg = this.checkResourceGroupExists(resourceGroupName);
        ResourceGroupOpStatus status = rg.registerUsage(fqNamespaceName.toString(), ResourceGroup.ResourceGroupRefTypes.Namespaces, false, this.resourceUsageTransportManagerMgr);
        if (status == ResourceGroupOpStatus.DoesNotExist) {
            String errMesg = String.format("Namespace %s does not yet reference resource group %s", fqNamespaceName, resourceGroupName);
            throw new PulsarAdminException(errMesg);
        }
        this.namespaceToRGsMap.remove(fqNamespaceName, rg);
        ((Counter.Child)rgNamespaceUnRegisters.labels(resourceGroupName)).inc();
    }

    public ResourceGroup getNamespaceResourceGroup(NamespaceName namespaceName) {
        return this.namespaceToRGsMap.get(namespaceName);
    }

    @Override
    public void close() throws Exception {
        if (this.aggregateLocalUsagePeriodicTask != null) {
            this.aggregateLocalUsagePeriodicTask.cancel(true);
        }
        if (this.calculateQuotaPeriodicTask != null) {
            this.calculateQuotaPeriodicTask.cancel(true);
        }
        this.resourceGroupsMap.clear();
        this.tenantToRGsMap.clear();
        this.namespaceToRGsMap.clear();
        this.topicProduceStats.clear();
        this.topicConsumeStats.clear();
    }

    protected boolean incrementUsage(String tenantName, String nsName, ResourceGroup.ResourceGroupMonitoringClass monClass, ResourceGroup.BytesAndMessagesCount incStats) throws PulsarAdminException {
        ResourceGroup nsRG = this.namespaceToRGsMap.get(NamespaceName.get(tenantName, nsName));
        ResourceGroup tenantRG = this.tenantToRGsMap.get(tenantName);
        if (tenantRG == null && nsRG == null) {
            return false;
        }
        if (incStats.bytes < 0L || incStats.messages < 0L) {
            String errMesg = String.format("incrementUsage on tenant=%s, NS=%s: bytes (%s) or mesgs (%s) is negative", tenantName, nsName, incStats.bytes, incStats.messages);
            throw new PulsarAdminException(errMesg);
        }
        if (nsRG == tenantRG) {
            nsRG.incrementLocalUsageStats(monClass, incStats);
            ((Counter.Child)rgLocalUsageMessages.labels(nsRG.resourceGroupName, monClass.name())).inc(incStats.messages);
            ((Counter.Child)rgLocalUsageBytes.labels(nsRG.resourceGroupName, monClass.name())).inc(incStats.bytes);
            return true;
        }
        if (tenantRG != null) {
            tenantRG.incrementLocalUsageStats(monClass, incStats);
            ((Counter.Child)rgLocalUsageMessages.labels(tenantRG.resourceGroupName, monClass.name())).inc(incStats.messages);
            ((Counter.Child)rgLocalUsageBytes.labels(tenantRG.resourceGroupName, monClass.name())).inc(incStats.bytes);
        }
        if (nsRG != null) {
            nsRG.incrementLocalUsageStats(monClass, incStats);
            ((Counter.Child)rgLocalUsageMessages.labels(nsRG.resourceGroupName, monClass.name())).inc(incStats.messages);
            ((Counter.Child)rgLocalUsageBytes.labels(nsRG.resourceGroupName, monClass.name())).inc(incStats.bytes);
        }
        return true;
    }

    protected ResourceGroup.BytesAndMessagesCount getRGUsage(String rgName, ResourceGroup.ResourceGroupMonitoringClass monClass, ResourceGroupUsageStatsType statsType) throws PulsarAdminException {
        ResourceGroup rg = this.getResourceGroupInternal(rgName);
        if (rg != null) {
            switch (statsType) {
                default: {
                    String errStr = "Unsupported statsType: " + (Object)((Object)statsType);
                    throw new PulsarAdminException(errStr);
                }
                case Cumulative: {
                    return rg.getLocalUsageStatsCumulative(monClass);
                }
                case LocalSinceLastReported: {
                    return rg.getLocalUsageStats(monClass);
                }
                case ReportFromTransportMgr: 
            }
            return rg.getLocalUsageStatsFromBrokerReports(monClass);
        }
        ResourceGroup.BytesAndMessagesCount retCount = new ResourceGroup.BytesAndMessagesCount();
        retCount.bytes = -1L;
        retCount.messages = -1L;
        return retCount;
    }

    private ResourceGroup getResourceGroupInternal(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Invalid null resource group name: " + resourceGroupName);
        }
        return this.resourceGroupsMap.get(resourceGroupName);
    }

    private ResourceGroup checkResourceGroupExists(String rgName) throws PulsarAdminException {
        ResourceGroup rg = this.getResourceGroupInternal(rgName);
        if (rg == null) {
            throw new PulsarAdminException("Resource group does not exist: " + rgName);
        }
        return rg;
    }

    private void updateStatsWithDiff(String topicName, String tenantString, String nsString, long accByteCount, long accMesgCount, ResourceGroup.ResourceGroupMonitoringClass monClass) {
        ConcurrentHashMap<String, ResourceGroup.BytesAndMessagesCount> hm;
        switch (monClass) {
            default: {
                log.error("updateStatsWithDiff: Unknown monitoring class={}; ignoring", (Object)monClass);
                return;
            }
            case Publish: {
                hm = this.topicProduceStats;
                break;
            }
            case Dispatch: {
                hm = this.topicConsumeStats;
            }
        }
        ResourceGroup.BytesAndMessagesCount bmDiff = new ResourceGroup.BytesAndMessagesCount();
        ResourceGroup.BytesAndMessagesCount bmNewCount = new ResourceGroup.BytesAndMessagesCount();
        bmNewCount.bytes = accByteCount;
        bmNewCount.messages = accMesgCount;
        ResourceGroup.BytesAndMessagesCount bmOldCount = hm.get(topicName);
        if (bmOldCount == null) {
            bmDiff.bytes = bmNewCount.bytes;
            bmDiff.messages = bmNewCount.messages;
        } else {
            bmDiff.bytes = bmNewCount.bytes - bmOldCount.bytes;
            bmDiff.messages = bmNewCount.messages - bmOldCount.messages;
        }
        if (bmDiff.bytes <= 0L || bmDiff.messages <= 0L) {
            return;
        }
        try {
            boolean statsUpdated = this.incrementUsage(tenantString, nsString, monClass, bmDiff);
            if (log.isDebugEnabled()) {
                log.debug("updateStatsWithDiff for topic={}: monclass={} statsUpdated={} for tenant={}, namespace={}; by {} bytes, {} mesgs", new Object[]{topicName, monClass, statsUpdated, tenantString, nsString, bmDiff.bytes, bmDiff.messages});
            }
            hm.put(topicName, bmNewCount);
        }
        catch (Throwable t) {
            log.error("updateStatsWithDiff: got ex={} while aggregating for {} side", (Object)t.getMessage(), (Object)monClass);
        }
    }

    protected ResourceGroup.BytesAndMessagesCount getPublishRateLimiters(String rgName) throws PulsarAdminException {
        ResourceGroup rg = this.getResourceGroupInternal(rgName);
        if (rg == null) {
            throw new PulsarAdminException("Resource group does not exist: " + rgName);
        }
        return rg.getRgPublishRateLimiterValues();
    }

    protected static double getRgQuotaByteCount(String rgName, String monClassName) {
        return ((Counter.Child)rgCalculatedQuotaBytes.labels(rgName, monClassName)).get();
    }

    protected static double getRgQuotaMessageCount(String rgName, String monClassName) {
        return ((Counter.Child)rgCalculatedQuotaMessages.labels(rgName, monClassName)).get();
    }

    protected static double getRgLocalUsageByteCount(String rgName, String monClassName) {
        return ((Counter.Child)rgLocalUsageBytes.labels(rgName, monClassName)).get();
    }

    protected static double getRgLocalUsageMessageCount(String rgName, String monClassName) {
        return ((Counter.Child)rgLocalUsageMessages.labels(rgName, monClassName)).get();
    }

    protected static double getRgUpdatesCount(String rgName) {
        return ((Counter.Child)rgUpdates.labels(rgName)).get();
    }

    protected static double getRgTenantRegistersCount(String rgName) {
        return ((Counter.Child)rgTenantRegisters.labels(rgName)).get();
    }

    protected static double getRgTenantUnRegistersCount(String rgName) {
        return ((Counter.Child)rgTenantUnRegisters.labels(rgName)).get();
    }

    protected static double getRgNamespaceRegistersCount(String rgName) {
        return ((Counter.Child)rgNamespaceRegisters.labels(rgName)).get();
    }

    protected static double getRgNamespaceUnRegistersCount(String rgName) {
        return ((Counter.Child)rgNamespaceUnRegisters.labels(rgName)).get();
    }

    protected static Summary.Child.Value getRgUsageAggregationLatency() {
        return rgUsageAggregationLatency.get();
    }

    protected static Summary.Child.Value getRgQuotaCalculationTime() {
        return rgQuotaCalculationLatency.get();
    }

    protected void aggregateResourceGroupLocalUsages() {
        ServiceConfiguration config;
        long newPeriodInSeconds;
        Summary.Timer aggrUsageTimer = rgUsageAggregationLatency.startTimer();
        BrokerService bs = this.pulsar.getBrokerService();
        Map<String, TopicStatsImpl> topicStatsMap = bs.getTopicStats();
        for (Map.Entry<String, TopicStatsImpl> entry : topicStatsMap.entrySet()) {
            String topicName = entry.getKey();
            TopicStats topicStats = entry.getValue();
            TopicName topic = TopicName.get(topicName);
            String tenantString = topic.getTenant();
            String nsString = topic.getNamespacePortion();
            NamespaceName fqNamespace = topic.getNamespaceObject();
            ResourceGroup tenantRG = this.tenantToRGsMap.get(tenantString);
            ResourceGroup namespaceRG = this.namespaceToRGsMap.get(fqNamespace);
            if (tenantRG == null && namespaceRG == null) continue;
            this.updateStatsWithDiff(topicName, tenantString, nsString, topicStats.getBytesInCounter(), topicStats.getMsgInCounter(), ResourceGroup.ResourceGroupMonitoringClass.Publish);
            this.updateStatsWithDiff(topicName, tenantString, nsString, topicStats.getBytesOutCounter(), topicStats.getMsgOutCounter(), ResourceGroup.ResourceGroupMonitoringClass.Dispatch);
        }
        double diffTimeSeconds = aggrUsageTimer.observeDuration();
        if (log.isDebugEnabled()) {
            log.debug("aggregateResourceGroupLocalUsages took {} milliseconds", (Object)(diffTimeSeconds * 1000.0));
        }
        if ((newPeriodInSeconds = (long)(config = this.pulsar.getConfiguration()).getResourceUsageTransportPublishIntervalInSecs()) != this.aggregateLocalUsagePeriodInSeconds) {
            if (this.aggregateLocalUsagePeriodicTask == null) {
                log.error("aggregateResourceGroupLocalUsages: Unable to find running task to cancel when publish period changed from {} to {} {}", new Object[]{this.aggregateLocalUsagePeriodInSeconds, newPeriodInSeconds, this.timeUnitScale});
            } else {
                boolean cancelStatus = this.aggregateLocalUsagePeriodicTask.cancel(true);
                log.info("aggregateResourceGroupLocalUsages: Got status={} in cancel of periodic when publish period changed from {} to {} {}", new Object[]{cancelStatus, this.aggregateLocalUsagePeriodInSeconds, newPeriodInSeconds, this.timeUnitScale});
            }
            this.aggregateLocalUsagePeriodicTask = this.pulsar.getExecutor().scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables(this::aggregateResourceGroupLocalUsages), newPeriodInSeconds, newPeriodInSeconds, this.timeUnitScale);
            this.aggregateLocalUsagePeriodInSeconds = newPeriodInSeconds;
        }
    }

    protected void calculateQuotaForAllResourceGroups() {
        ServiceConfiguration config;
        long newPeriodInSeconds;
        Summary.Timer quotaCalcTimer = rgQuotaCalculationLatency.startTimer();
        ResourceGroup.BytesAndMessagesCount updatedQuota = new ResourceGroup.BytesAndMessagesCount();
        this.resourceGroupsMap.forEach((rgName, resourceGroup) -> {
            for (ResourceGroup.ResourceGroupMonitoringClass monClass : ResourceGroup.ResourceGroupMonitoringClass.values()) {
                try {
                    ResourceGroup.BytesAndMessagesCount globalUsageStats = resourceGroup.getGlobalUsageStats(monClass);
                    ResourceGroup.BytesAndMessagesCount localUsageStats = resourceGroup.getLocalUsageStatsFromBrokerReports(monClass);
                    ResourceGroup.BytesAndMessagesCount confCounts = resourceGroup.getConfLimits(monClass);
                    long[] globUsageBytesArray = new long[]{globalUsageStats.bytes};
                    updatedQuota.bytes = this.quotaCalculator.computeLocalQuota(confCounts.bytes, localUsageStats.bytes, globUsageBytesArray);
                    long[] globUsageMessagesArray = new long[]{globalUsageStats.messages};
                    updatedQuota.messages = this.quotaCalculator.computeLocalQuota(confCounts.messages, localUsageStats.messages, globUsageMessagesArray);
                    ResourceGroup.BytesAndMessagesCount oldBMCount = resourceGroup.updateLocalQuota(monClass, updatedQuota);
                    if (updatedQuota.messages >= 0L) {
                        ((Counter.Child)rgCalculatedQuotaMessages.labels((String)rgName, monClass.name())).inc(updatedQuota.messages);
                    }
                    if (updatedQuota.bytes >= 0L) {
                        ((Counter.Child)rgCalculatedQuotaBytes.labels((String)rgName, monClass.name())).inc(updatedQuota.bytes);
                    }
                    if (oldBMCount != null) {
                        long messagesIncrement = updatedQuota.messages - oldBMCount.messages;
                        long bytesIncrement = updatedQuota.bytes - oldBMCount.bytes;
                        if (!log.isDebugEnabled()) continue;
                        log.debug("calculateQuota for RG={} [class {}]: updatedlocalBytes={}, updatedlocalMesgs={}; old bytes={}, old mesgs={};  incremented bytes by {}, messages by {}", new Object[]{rgName, monClass, updatedQuota.bytes, updatedQuota.messages, oldBMCount.bytes, oldBMCount.messages, bytesIncrement, messagesIncrement});
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("calculateQuota for RG={} [class {}]: got back null from updateLocalQuota", rgName, (Object)monClass);
                }
                catch (Throwable t) {
                    log.error("Got exception={} while calculating new quota for monitoring-class={} of RG={}", new Object[]{t.getMessage(), monClass, rgName});
                }
            }
        });
        double diffTimeSeconds = quotaCalcTimer.observeDuration();
        if (log.isDebugEnabled()) {
            log.debug("calculateQuotaForAllResourceGroups took {} milliseconds", (Object)(diffTimeSeconds * 1000.0));
        }
        if ((newPeriodInSeconds = (long)(config = this.pulsar.getConfiguration()).getResourceUsageTransportPublishIntervalInSecs()) != this.resourceUsagePublishPeriodInSeconds) {
            if (this.calculateQuotaPeriodicTask == null) {
                log.error("calculateQuotaForAllResourceGroups: Unable to find running task to cancel when publish period changed from {} to {} {}", new Object[]{this.resourceUsagePublishPeriodInSeconds, newPeriodInSeconds, this.timeUnitScale});
            } else {
                boolean cancelStatus = this.calculateQuotaPeriodicTask.cancel(true);
                log.info("calculateQuotaForAllResourceGroups: Got status={} in cancel of periodic  when publish period changed from {} to {} {}", new Object[]{cancelStatus, this.resourceUsagePublishPeriodInSeconds, newPeriodInSeconds, this.timeUnitScale});
            }
            this.calculateQuotaPeriodicTask = this.pulsar.getExecutor().scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables(this::calculateQuotaForAllResourceGroups), newPeriodInSeconds, newPeriodInSeconds, this.timeUnitScale);
            this.resourceUsagePublishPeriodInSeconds = newPeriodInSeconds;
            maxIntervalForSuppressingReportsMSecs = this.resourceUsagePublishPeriodInSeconds * 5L;
        }
    }

    private void initialize() {
        long periodInSecs;
        ServiceConfiguration config = this.pulsar.getConfiguration();
        this.aggregateLocalUsagePeriodInSeconds = this.resourceUsagePublishPeriodInSeconds = (periodInSecs = (long)config.getResourceUsageTransportPublishIntervalInSecs());
        this.aggregateLocalUsagePeriodicTask = this.pulsar.getExecutor().scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables(this::aggregateResourceGroupLocalUsages), periodInSecs, periodInSecs, this.timeUnitScale);
        this.calculateQuotaPeriodicTask = this.pulsar.getExecutor().scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables(this::calculateQuotaForAllResourceGroups), periodInSecs, periodInSecs, this.timeUnitScale);
        maxIntervalForSuppressingReportsMSecs = this.resourceUsagePublishPeriodInSeconds * 5L;
    }

    private void checkRGCreateParams(String rgName, org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ResourceGroup rgConfig) throws PulsarAdminException {
        if (rgConfig == null) {
            throw new IllegalArgumentException("ResourceGroupCreate: Invalid null ResourceGroup config");
        }
        if (rgName.isEmpty()) {
            throw new IllegalArgumentException("ResourceGroupCreate: can't create resource group with an empty name");
        }
        ResourceGroup rg = this.getResourceGroupInternal(rgName);
        if (rg != null) {
            throw new PulsarAdminException("Resource group already exists:" + rgName);
        }
    }

    @VisibleForTesting
    ConcurrentHashMap getTopicConsumeStats() {
        return this.topicConsumeStats;
    }

    @VisibleForTesting
    ConcurrentHashMap getTopicProduceStats() {
        return this.topicProduceStats;
    }

    @VisibleForTesting
    ScheduledFuture<?> getAggregateLocalUsagePeriodicTask() {
        return this.aggregateLocalUsagePeriodicTask;
    }

    @VisibleForTesting
    ScheduledFuture<?> getCalculateQuotaPeriodicTask() {
        return this.calculateQuotaPeriodicTask;
    }

    public PulsarService getPulsar() {
        return this.pulsar;
    }

    static {
        resourceGroupLabel = new String[]{"ResourceGroup"};
        resourceGroupMonitoringclassLabels = new String[]{"ResourceGroup", "MonitoringClass"};
        rgCalculatedQuotaBytes = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_resource_group_calculated_bytes_quota")).help("Bytes quota calculated for resource group")).labelNames(resourceGroupMonitoringclassLabels)).register();
        rgCalculatedQuotaMessages = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_resource_group_calculated_messages_quota")).help("Messages quota calculated for resource group")).labelNames(resourceGroupMonitoringclassLabels)).register();
        rgLocalUsageBytes = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_resource_group_bytes_used")).help("Bytes locally used within this resource group during the last aggregation interval")).labelNames(resourceGroupMonitoringclassLabels)).register();
        rgLocalUsageMessages = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_resource_group_messages_used")).help("Messages locally used within this resource group during the last aggregation interval")).labelNames(resourceGroupMonitoringclassLabels)).register();
        rgUpdates = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_resource_group_updates")).help("Number of update operations on the given resource group")).labelNames(resourceGroupLabel)).register();
        rgTenantRegisters = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_resource_group_tenant_registers")).help("Number of registrations of tenants")).labelNames(resourceGroupLabel)).register();
        rgTenantUnRegisters = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_resource_group_tenant_unregisters")).help("Number of un-registrations of tenants")).labelNames(resourceGroupLabel)).register();
        rgNamespaceRegisters = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_resource_group_namespace_registers")).help("Number of registrations of namespaces")).labelNames(resourceGroupLabel)).register();
        rgNamespaceUnRegisters = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_resource_group_namespace_unregisters")).help("Number of un-registrations of namespaces")).labelNames(resourceGroupLabel)).register();
        rgUsageAggregationLatency = (Summary)((Summary.Builder)((Summary.Builder)Summary.build().quantile(0.5, 0.05).quantile(0.9, 0.01).name("pulsar_resource_group_aggregate_usage_secs")).help("Time required to aggregate usage of all resource groups, in seconds.")).register();
        rgQuotaCalculationLatency = (Summary)((Summary.Builder)((Summary.Builder)Summary.build().quantile(0.5, 0.05).quantile(0.9, 0.01).name("pulsar_resource_group_calculate_quota_secs")).help("Time required to calculate quota of all resource groups, in seconds.")).register();
    }

    protected static enum ResourceGroupUsageStatsType {
        Cumulative,
        LocalSinceLastReported,
        ReportFromTransportMgr;

    }

    protected static enum ResourceGroupOpStatus {
        OK,
        Exists,
        DoesNotExist,
        NotSupported;

    }
}

