/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.pulsar.broker.service.TransportCnx;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.KeyValue;

public class SubscriptionOption {
    private final TransportCnx cnx;
    private String subscriptionName;
    private long consumerId;
    private CommandSubscribe.SubType subType;
    private int priorityLevel;
    private String consumerName;
    private boolean isDurable;
    private MessageId startMessageId;
    private Map<String, String> metadata;
    private boolean readCompacted;
    private CommandSubscribe.InitialPosition initialPosition;
    private long startMessageRollbackDurationSec;
    private boolean replicatedSubscriptionStateArg;
    private KeySharedMeta keySharedMeta;
    private Optional<Map<String, String>> subscriptionProperties;
    private long consumerEpoch;

    public static Optional<Map<String, String>> getPropertiesMap(List<KeyValue> list) {
        if (list == null) {
            return Optional.of(Collections.emptyMap());
        }
        return Optional.of(list.stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue, (key1, key2) -> key1)));
    }

    SubscriptionOption(TransportCnx cnx, String subscriptionName, long consumerId, CommandSubscribe.SubType subType, int priorityLevel, String consumerName, boolean isDurable, MessageId startMessageId, Map<String, String> metadata, boolean readCompacted, CommandSubscribe.InitialPosition initialPosition, long startMessageRollbackDurationSec, boolean replicatedSubscriptionStateArg, KeySharedMeta keySharedMeta, Optional<Map<String, String>> subscriptionProperties, long consumerEpoch) {
        this.cnx = cnx;
        this.subscriptionName = subscriptionName;
        this.consumerId = consumerId;
        this.subType = subType;
        this.priorityLevel = priorityLevel;
        this.consumerName = consumerName;
        this.isDurable = isDurable;
        this.startMessageId = startMessageId;
        this.metadata = metadata;
        this.readCompacted = readCompacted;
        this.initialPosition = initialPosition;
        this.startMessageRollbackDurationSec = startMessageRollbackDurationSec;
        this.replicatedSubscriptionStateArg = replicatedSubscriptionStateArg;
        this.keySharedMeta = keySharedMeta;
        this.subscriptionProperties = subscriptionProperties;
        this.consumerEpoch = consumerEpoch;
    }

    public static SubscriptionOptionBuilder builder() {
        return new SubscriptionOptionBuilder();
    }

    public TransportCnx getCnx() {
        return this.cnx;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public long getConsumerId() {
        return this.consumerId;
    }

    public CommandSubscribe.SubType getSubType() {
        return this.subType;
    }

    public int getPriorityLevel() {
        return this.priorityLevel;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public boolean isDurable() {
        return this.isDurable;
    }

    public MessageId getStartMessageId() {
        return this.startMessageId;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public boolean isReadCompacted() {
        return this.readCompacted;
    }

    public CommandSubscribe.InitialPosition getInitialPosition() {
        return this.initialPosition;
    }

    public long getStartMessageRollbackDurationSec() {
        return this.startMessageRollbackDurationSec;
    }

    public boolean isReplicatedSubscriptionStateArg() {
        return this.replicatedSubscriptionStateArg;
    }

    public KeySharedMeta getKeySharedMeta() {
        return this.keySharedMeta;
    }

    public Optional<Map<String, String>> getSubscriptionProperties() {
        return this.subscriptionProperties;
    }

    public long getConsumerEpoch() {
        return this.consumerEpoch;
    }

    public static class SubscriptionOptionBuilder {
        private TransportCnx cnx;
        private String subscriptionName;
        private long consumerId;
        private CommandSubscribe.SubType subType;
        private int priorityLevel;
        private String consumerName;
        private boolean isDurable;
        private MessageId startMessageId;
        private Map<String, String> metadata;
        private boolean readCompacted;
        private CommandSubscribe.InitialPosition initialPosition;
        private long startMessageRollbackDurationSec;
        private boolean replicatedSubscriptionStateArg;
        private KeySharedMeta keySharedMeta;
        private Optional<Map<String, String>> subscriptionProperties;
        private long consumerEpoch;

        SubscriptionOptionBuilder() {
        }

        public SubscriptionOptionBuilder cnx(TransportCnx cnx) {
            this.cnx = cnx;
            return this;
        }

        public SubscriptionOptionBuilder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public SubscriptionOptionBuilder consumerId(long consumerId) {
            this.consumerId = consumerId;
            return this;
        }

        public SubscriptionOptionBuilder subType(CommandSubscribe.SubType subType) {
            this.subType = subType;
            return this;
        }

        public SubscriptionOptionBuilder priorityLevel(int priorityLevel) {
            this.priorityLevel = priorityLevel;
            return this;
        }

        public SubscriptionOptionBuilder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public SubscriptionOptionBuilder isDurable(boolean isDurable) {
            this.isDurable = isDurable;
            return this;
        }

        public SubscriptionOptionBuilder startMessageId(MessageId startMessageId) {
            this.startMessageId = startMessageId;
            return this;
        }

        public SubscriptionOptionBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public SubscriptionOptionBuilder readCompacted(boolean readCompacted) {
            this.readCompacted = readCompacted;
            return this;
        }

        public SubscriptionOptionBuilder initialPosition(CommandSubscribe.InitialPosition initialPosition) {
            this.initialPosition = initialPosition;
            return this;
        }

        public SubscriptionOptionBuilder startMessageRollbackDurationSec(long startMessageRollbackDurationSec) {
            this.startMessageRollbackDurationSec = startMessageRollbackDurationSec;
            return this;
        }

        public SubscriptionOptionBuilder replicatedSubscriptionStateArg(boolean replicatedSubscriptionStateArg) {
            this.replicatedSubscriptionStateArg = replicatedSubscriptionStateArg;
            return this;
        }

        public SubscriptionOptionBuilder keySharedMeta(KeySharedMeta keySharedMeta) {
            this.keySharedMeta = keySharedMeta;
            return this;
        }

        public SubscriptionOptionBuilder subscriptionProperties(Optional<Map<String, String>> subscriptionProperties) {
            this.subscriptionProperties = subscriptionProperties;
            return this;
        }

        public SubscriptionOptionBuilder consumerEpoch(long consumerEpoch) {
            this.consumerEpoch = consumerEpoch;
            return this;
        }

        public SubscriptionOption build() {
            return new SubscriptionOption(this.cnx, this.subscriptionName, this.consumerId, this.subType, this.priorityLevel, this.consumerName, this.isDurable, this.startMessageId, this.metadata, this.readCompacted, this.initialPosition, this.startMessageRollbackDurationSec, this.replicatedSubscriptionStateArg, this.keySharedMeta, this.subscriptionProperties, this.consumerEpoch);
        }

        public String toString() {
            return "SubscriptionOption.SubscriptionOptionBuilder(cnx=" + this.cnx + ", subscriptionName=" + this.subscriptionName + ", consumerId=" + this.consumerId + ", subType=" + (Object)((Object)this.subType) + ", priorityLevel=" + this.priorityLevel + ", consumerName=" + this.consumerName + ", isDurable=" + this.isDurable + ", startMessageId=" + this.startMessageId + ", metadata=" + this.metadata + ", readCompacted=" + this.readCompacted + ", initialPosition=" + (Object)((Object)this.initialPosition) + ", startMessageRollbackDurationSec=" + this.startMessageRollbackDurationSec + ", replicatedSubscriptionStateArg=" + this.replicatedSubscriptionStateArg + ", keySharedMeta=" + this.keySharedMeta + ", subscriptionProperties=" + this.subscriptionProperties + ", consumerEpoch=" + this.consumerEpoch + ")";
        }
    }
}

