/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.pulsar.broker.service.schema.AlwaysSchemaValidator;
import org.apache.pulsar.broker.service.schema.NeverSchemaValidator;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.SchemaParseException;
import org.apache.pulsar.shade.org.apache.avro.SchemaValidationException;
import org.apache.pulsar.shade.org.apache.avro.SchemaValidator;
import org.apache.pulsar.shade.org.apache.avro.SchemaValidatorBuilder;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.SchemaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AvroSchemaBasedCompatibilityCheck
implements SchemaCompatibilityCheck {
    private static final Logger log = LoggerFactory.getLogger(AvroSchemaBasedCompatibilityCheck.class);

    AvroSchemaBasedCompatibilityCheck() {
    }

    @Override
    public void checkCompatible(SchemaData from, SchemaData to, SchemaCompatibilityStrategy strategy) throws IncompatibleSchemaException {
        this.checkCompatible(Collections.singletonList(from), to, strategy);
    }

    @Override
    public void checkCompatible(Iterable<SchemaData> from, SchemaData to, SchemaCompatibilityStrategy strategy) throws IncompatibleSchemaException {
        LinkedList<Schema> fromList = new LinkedList<Schema>();
        Preconditions.checkArgument(from != null, "check compatibility list is null");
        try {
            for (SchemaData schemaData : from) {
                Schema.Parser parser = new Schema.Parser();
                parser.setValidateDefaults(false);
                fromList.addFirst(parser.parse(new String(schemaData.getData(), StandardCharsets.UTF_8)));
            }
            Schema.Parser parser = new Schema.Parser();
            parser.setValidateDefaults(false);
            Schema toSchema = parser.parse(new String(to.getData(), StandardCharsets.UTF_8));
            SchemaValidator schemaValidator = AvroSchemaBasedCompatibilityCheck.createSchemaValidator(strategy);
            schemaValidator.validate(toSchema, fromList);
        }
        catch (SchemaParseException e) {
            log.warn("Error during schema parsing: {}", (Object)e.getMessage());
            throw new IncompatibleSchemaException(e);
        }
        catch (SchemaValidationException e) {
            log.warn("Error during schema compatibility check: {}", (Object)e.getMessage());
            throw new IncompatibleSchemaException(e);
        }
    }

    static SchemaValidator createSchemaValidator(SchemaCompatibilityStrategy compatibilityStrategy) {
        SchemaValidatorBuilder validatorBuilder = new SchemaValidatorBuilder();
        switch (compatibilityStrategy) {
            case BACKWARD_TRANSITIVE: {
                return AvroSchemaBasedCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.canReadStrategy(), false);
            }
            case BACKWARD: {
                return AvroSchemaBasedCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.canReadStrategy(), true);
            }
            case FORWARD_TRANSITIVE: {
                return AvroSchemaBasedCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.canBeReadStrategy(), false);
            }
            case FORWARD: {
                return AvroSchemaBasedCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.canBeReadStrategy(), true);
            }
            case FULL_TRANSITIVE: {
                return AvroSchemaBasedCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.mutualReadStrategy(), false);
            }
            case FULL: {
                return AvroSchemaBasedCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.mutualReadStrategy(), true);
            }
            case ALWAYS_COMPATIBLE: {
                return AlwaysSchemaValidator.INSTANCE;
            }
        }
        return NeverSchemaValidator.INSTANCE;
    }

    static SchemaValidator createLatestOrAllValidator(SchemaValidatorBuilder validatorBuilder, boolean onlyLatest) {
        return onlyLatest ? validatorBuilder.validateLatest() : validatorBuilder.validateAll();
    }
}

