/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.validator;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.configuration.BindAddress;

public class BindAddressValidator {
    private static final Pattern BIND_ADDRESSES_PATTERN = Pattern.compile("(?<name>\\w+):(?<url>.+)$");

    public static List<BindAddress> validateBindAddresses(ServiceConfiguration config, Collection<String> schemes) {
        List<BindAddress> addresses = BindAddressValidator.migrateBindAddresses(config);
        Arrays.stream(StringUtils.split(StringUtils.defaultString(config.getBindAddresses()), ",")).map(s -> {
            Matcher m = BIND_ADDRESSES_PATTERN.matcher((CharSequence)s);
            if (!m.matches()) {
                throw new IllegalArgumentException("bindAddresses: malformed: " + s);
            }
            return m;
        }).map(m -> new BindAddress(m.group("name"), URI.create(m.group("url")))).forEach(addresses::add);
        if (schemes != null) {
            addresses.removeIf(a -> !schemes.contains(a.getAddress().getScheme()));
        }
        return addresses;
    }

    private static List<BindAddress> migrateBindAddresses(ServiceConfiguration config) {
        ArrayList<BindAddress> addresses = new ArrayList<BindAddress>(2);
        if (config.getBrokerServicePort().isPresent()) {
            addresses.add(new BindAddress(null, URI.create(ServiceConfigurationUtils.brokerUrl(config.getBindAddress(), config.getBrokerServicePort().get()))));
        }
        if (config.getBrokerServicePortTls().isPresent()) {
            addresses.add(new BindAddress(null, URI.create(ServiceConfigurationUtils.brokerUrlTls(config.getBindAddress(), config.getBrokerServicePortTls().get()))));
        }
        if (config.getWebServicePort().isPresent()) {
            addresses.add(new BindAddress(null, URI.create(ServiceConfigurationUtils.webServiceUrl(config.getBindAddress(), config.getWebServicePort().get()))));
        }
        if (config.getWebServicePortTls().isPresent()) {
            addresses.add(new BindAddress(null, URI.create(ServiceConfigurationUtils.webServiceUrlTls(config.getBindAddress(), config.getWebServicePortTls().get()))));
        }
        return addresses;
    }
}

