/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.admin.Namespaces;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.WebTargets;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SubscriptionAuthMode;

public class NamespacesImpl
extends BaseResource
implements Namespaces {
    private final WebTarget adminNamespaces;
    private final WebTarget adminV2Namespaces;

    public NamespacesImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminNamespaces = web.path("/admin/namespaces");
        this.adminV2Namespaces = web.path("/admin/v2/namespaces");
    }

    @Override
    public List<String> getNamespaces(String tenant) throws PulsarAdminException {
        return (List)this.sync(() -> this.getNamespacesAsync(tenant));
    }

    @Override
    public CompletableFuture<List<String>> getNamespacesAsync(String tenant) {
        WebTarget path = this.adminV2Namespaces.path(tenant);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> namespaces) {
                future.complete(namespaces);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public List<String> getNamespaces(String tenant, String cluster) throws PulsarAdminException {
        return (List)this.sync(() -> this.getNamespacesAsync(tenant, cluster));
    }

    public CompletableFuture<List<String>> getNamespacesAsync(String tenant, String cluster) {
        WebTarget path = this.adminNamespaces.path(tenant).path(cluster);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> namespaces) {
                future.complete(namespaces);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public List<String> getTopics(String namespace) throws PulsarAdminException {
        return (List)this.sync(() -> this.getTopicsAsync(namespace));
    }

    @Override
    public BundlesData getBundles(String namespace) throws PulsarAdminException {
        return (BundlesData)this.sync(() -> this.getBundlesAsync(namespace));
    }

    @Override
    public CompletableFuture<BundlesData> getBundlesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        String action = "bundles";
        WebTarget path = this.namespacePath(ns, action);
        final CompletableFuture<BundlesData> future = new CompletableFuture<BundlesData>();
        this.asyncGetRequest(path, new InvocationCallback<BundlesData>(){

            @Override
            public void completed(BundlesData bundles) {
                future.complete(bundles);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<List<String>> getTopicsAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        String action = ns.isV2() ? "topics" : "destinations";
        WebTarget path = this.namespacePath(ns, action);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> topics) {
                future.complete(topics);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public Policies getPolicies(String namespace) throws PulsarAdminException {
        return (Policies)this.sync(() -> this.getPoliciesAsync(namespace));
    }

    @Override
    public CompletableFuture<Policies> getPoliciesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, new String[0]);
        final CompletableFuture<Policies> future = new CompletableFuture<Policies>();
        this.asyncGetRequest(path, new InvocationCallback<Policies>(){

            @Override
            public void completed(Policies policies) {
                future.complete(policies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void createNamespace(String namespace, Set<String> clusters) throws PulsarAdminException {
        this.sync(() -> this.createNamespaceAsync(namespace, clusters));
    }

    @Override
    public CompletableFuture<Void> createNamespaceAsync(String namespace, Set<String> clusters) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, new String[0]);
        if (ns.isV2()) {
            Policies policies = new Policies();
            policies.replication_clusters = clusters;
            return this.asyncPutRequest(path, Entity.entity(policies, "application/json"));
        }
        return this.asyncPutRequest(path, Entity.entity("", "application/json")).thenAccept(ignore -> this.setNamespaceReplicationClustersAsync(namespace, clusters));
    }

    @Override
    public void createNamespace(String namespace, int numBundles) throws PulsarAdminException {
        this.createNamespace(namespace, BundlesData.builder().numBundles(numBundles).build());
    }

    @Override
    public CompletableFuture<Void> createNamespaceAsync(String namespace, int numBundles) {
        return this.createNamespaceAsync(namespace, BundlesData.builder().numBundles(numBundles).build());
    }

    @Override
    public void createNamespace(String namespace, Policies policies) throws PulsarAdminException {
        this.sync(() -> this.createNamespaceAsync(namespace, policies));
    }

    @Override
    public CompletableFuture<Void> createNamespaceAsync(String namespace, Policies policies) {
        NamespaceName ns = NamespaceName.get(namespace);
        Preconditions.checkArgument(ns.isV2(), "Create namespace with policies is only supported on newer namespaces");
        WebTarget path = this.namespacePath(ns, new String[0]);
        return this.asyncPutRequest(path, Entity.entity(policies, "application/json"));
    }

    @Override
    public void createNamespace(String namespace, BundlesData bundlesData) throws PulsarAdminException {
        this.sync(() -> this.createNamespaceAsync(namespace, bundlesData));
    }

    @Override
    public CompletableFuture<Void> createNamespaceAsync(String namespace, BundlesData bundlesData) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, new String[0]);
        if (ns.isV2()) {
            Policies policies = new Policies();
            policies.bundles = bundlesData;
            return this.asyncPutRequest(path, Entity.entity(policies, "application/json"));
        }
        return this.asyncPutRequest(path, Entity.entity(bundlesData, "application/json"));
    }

    @Override
    public void createNamespace(String namespace) throws PulsarAdminException {
        this.sync(() -> this.createNamespaceAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> createNamespaceAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, new String[0]);
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void deleteNamespace(String namespace) throws PulsarAdminException {
        this.sync(() -> this.deleteNamespaceAsync(namespace));
    }

    @Override
    public void deleteNamespace(String namespace, boolean force) throws PulsarAdminException {
        this.sync(() -> this.deleteNamespaceAsync(namespace, force));
    }

    @Override
    public CompletableFuture<Void> deleteNamespaceAsync(String namespace) {
        return this.deleteNamespaceAsync(namespace, false);
    }

    @Override
    public CompletableFuture<Void> deleteNamespaceAsync(String namespace, boolean force) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, new String[0]);
        path = path.queryParam("force", force);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void deleteNamespaceBundle(String namespace, String bundleRange) throws PulsarAdminException {
        this.sync(() -> this.deleteNamespaceBundleAsync(namespace, bundleRange));
    }

    @Override
    public void deleteNamespaceBundle(String namespace, String bundleRange, boolean force) throws PulsarAdminException {
        this.sync(() -> this.deleteNamespaceBundleAsync(namespace, bundleRange, force));
    }

    @Override
    public CompletableFuture<Void> deleteNamespaceBundleAsync(String namespace, String bundleRange) {
        return this.deleteNamespaceBundleAsync(namespace, bundleRange, false);
    }

    @Override
    public CompletableFuture<Void> deleteNamespaceBundleAsync(String namespace, String bundleRange, boolean force) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundleRange);
        path = path.queryParam("force", force);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Map<String, Set<AuthAction>> getPermissions(String namespace) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getPermissionsAsync(namespace));
    }

    @Override
    public CompletableFuture<Map<String, Set<AuthAction>>> getPermissionsAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions");
        final CompletableFuture<Map<String, Set<AuthAction>>> future = new CompletableFuture<Map<String, Set<AuthAction>>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<String, Set<AuthAction>>>(){

            @Override
            public void completed(Map<String, Set<AuthAction>> permissions) {
                future.complete(permissions);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void grantPermissionOnNamespace(String namespace, String role, Set<AuthAction> actions) throws PulsarAdminException {
        this.sync(() -> this.grantPermissionOnNamespaceAsync(namespace, role, actions));
    }

    @Override
    public CompletableFuture<Void> grantPermissionOnNamespaceAsync(String namespace, String role, Set<AuthAction> actions) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions", role);
        return this.asyncPostRequest(path, Entity.entity(actions, "application/json"));
    }

    @Override
    public void revokePermissionsOnNamespace(String namespace, String role) throws PulsarAdminException {
        this.sync(() -> this.revokePermissionsOnNamespaceAsync(namespace, role));
    }

    @Override
    public CompletableFuture<Void> revokePermissionsOnNamespaceAsync(String namespace, String role) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions", role);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Map<String, Set<String>> getPermissionOnSubscription(String namespace) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getPermissionOnSubscriptionAsync(namespace));
    }

    @Override
    public CompletableFuture<Map<String, Set<String>>> getPermissionOnSubscriptionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions", "subscription");
        final CompletableFuture<Map<String, Set<String>>> future = new CompletableFuture<Map<String, Set<String>>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<String, Set<String>>>(){

            @Override
            public void completed(Map<String, Set<String>> permissions) {
                future.complete(permissions);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void grantPermissionOnSubscription(String namespace, String subscription, Set<String> roles) throws PulsarAdminException {
        this.sync(() -> this.grantPermissionOnSubscriptionAsync(namespace, subscription, roles));
    }

    @Override
    public CompletableFuture<Void> grantPermissionOnSubscriptionAsync(String namespace, String subscription, Set<String> roles) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions", "subscription", subscription);
        return this.asyncPostRequest(path, Entity.entity(roles, "application/json"));
    }

    @Override
    public void revokePermissionOnSubscription(String namespace, String subscription, String role) throws PulsarAdminException {
        this.sync(() -> this.revokePermissionOnSubscriptionAsync(namespace, subscription, role));
    }

    @Override
    public CompletableFuture<Void> revokePermissionOnSubscriptionAsync(String namespace, String subscription, String role) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions", subscription, role);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public List<String> getNamespaceReplicationClusters(String namespace) throws PulsarAdminException {
        return (List)this.sync(() -> this.getNamespaceReplicationClustersAsync(namespace));
    }

    @Override
    public CompletableFuture<List<String>> getNamespaceReplicationClustersAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "replication");
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> clusters) {
                future.complete(clusters);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setNamespaceReplicationClusters(String namespace, Set<String> clusterIds) throws PulsarAdminException {
        this.sync(() -> this.setNamespaceReplicationClustersAsync(namespace, clusterIds));
    }

    @Override
    public CompletableFuture<Void> setNamespaceReplicationClustersAsync(String namespace, Set<String> clusterIds) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "replication");
        return this.asyncPostRequest(path, Entity.entity(clusterIds, "application/json"));
    }

    @Override
    public Integer getNamespaceMessageTTL(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getNamespaceMessageTTLAsync(namespace));
    }

    @Override
    public CompletableFuture<Integer> getNamespaceMessageTTLAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "messageTTL");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer ttl) {
                future.complete(ttl);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setNamespaceMessageTTL(String namespace, int ttlInSeconds) throws PulsarAdminException {
        this.sync(() -> this.setNamespaceMessageTTLAsync(namespace, ttlInSeconds));
    }

    @Override
    public CompletableFuture<Void> setNamespaceMessageTTLAsync(String namespace, int ttlInSeconds) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "messageTTL");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(ttlInSeconds), "application/json"));
    }

    @Override
    public void removeNamespaceMessageTTL(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeNamespaceMessageTTLAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeNamespaceMessageTTLAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "messageTTL");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Integer getSubscriptionExpirationTime(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getSubscriptionExpirationTimeAsync(namespace));
    }

    @Override
    public CompletableFuture<Integer> getSubscriptionExpirationTimeAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionExpirationTime");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer expirationTime) {
                future.complete(expirationTime);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setSubscriptionExpirationTime(String namespace, int expirationTime) throws PulsarAdminException {
        this.sync(() -> this.setSubscriptionExpirationTimeAsync(namespace, expirationTime));
    }

    @Override
    public CompletableFuture<Void> setSubscriptionExpirationTimeAsync(String namespace, int expirationTime) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionExpirationTime");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(expirationTime), "application/json"));
    }

    @Override
    public void removeSubscriptionExpirationTime(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeSubscriptionExpirationTimeAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeSubscriptionExpirationTimeAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionExpirationTime");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void setNamespaceAntiAffinityGroup(String namespace, String namespaceAntiAffinityGroup) throws PulsarAdminException {
        this.sync(() -> this.setNamespaceAntiAffinityGroupAsync(namespace, namespaceAntiAffinityGroup));
    }

    @Override
    public CompletableFuture<Void> setNamespaceAntiAffinityGroupAsync(String namespace, String namespaceAntiAffinityGroup) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "antiAffinity");
        return this.asyncPostRequest(path, Entity.entity(namespaceAntiAffinityGroup, "application/json"));
    }

    @Override
    public String getNamespaceAntiAffinityGroup(String namespace) throws PulsarAdminException {
        return (String)this.sync(() -> this.getNamespaceAntiAffinityGroupAsync(namespace));
    }

    @Override
    public CompletableFuture<String> getNamespaceAntiAffinityGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "antiAffinity");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String s) {
                future.complete(s);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public List<String> getAntiAffinityNamespaces(String tenant, String cluster, String namespaceAntiAffinityGroup) throws PulsarAdminException {
        return (List)this.sync(() -> this.getAntiAffinityNamespacesAsync(tenant, cluster, namespaceAntiAffinityGroup));
    }

    @Override
    public CompletableFuture<List<String>> getAntiAffinityNamespacesAsync(String tenant, String cluster, String namespaceAntiAffinityGroup) {
        WebTarget path = this.adminNamespaces.path(cluster).path("antiAffinity").path(namespaceAntiAffinityGroup).queryParam("property", tenant);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> antiNamespaces) {
                future.complete(antiNamespaces);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void deleteNamespaceAntiAffinityGroup(String namespace) throws PulsarAdminException {
        this.sync(() -> this.deleteNamespaceAntiAffinityGroupAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> deleteNamespaceAntiAffinityGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "antiAffinity");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void removeDeduplicationStatus(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeDeduplicationStatusAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeDeduplicationStatusAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "deduplication");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Boolean getDeduplicationStatus(String namespace) throws PulsarAdminException {
        return (Boolean)this.sync(() -> this.getDeduplicationStatusAsync(namespace));
    }

    @Override
    public CompletableFuture<Boolean> getDeduplicationStatusAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "deduplication");
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.asyncGetRequest(path, new InvocationCallback<Boolean>(){

            @Override
            public void completed(Boolean enabled) {
                future.complete(enabled);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setDeduplicationStatus(String namespace, boolean enableDeduplication) throws PulsarAdminException {
        this.sync(() -> this.setDeduplicationStatusAsync(namespace, enableDeduplication));
    }

    @Override
    public CompletableFuture<Void> setDeduplicationStatusAsync(String namespace, boolean enableDeduplication) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "deduplication");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(enableDeduplication), "application/json"));
    }

    @Override
    public void setAutoTopicCreation(String namespace, AutoTopicCreationOverride autoTopicCreationOverride) throws PulsarAdminException {
        this.sync(() -> this.setAutoTopicCreationAsync(namespace, autoTopicCreationOverride));
    }

    @Override
    public CompletableFuture<Void> setAutoTopicCreationAsync(String namespace, AutoTopicCreationOverride autoTopicCreationOverride) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "autoTopicCreation");
        return this.asyncPostRequest(path, Entity.entity(autoTopicCreationOverride, "application/json"));
    }

    @Override
    public AutoTopicCreationOverride getAutoTopicCreation(String namespace) throws PulsarAdminException {
        return (AutoTopicCreationOverride)this.sync(() -> this.getAutoTopicCreationAsync(namespace));
    }

    @Override
    public CompletableFuture<AutoTopicCreationOverride> getAutoTopicCreationAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "autoTopicCreation");
        final CompletableFuture<AutoTopicCreationOverride> future = new CompletableFuture<AutoTopicCreationOverride>();
        this.asyncGetRequest(path, new InvocationCallback<AutoTopicCreationOverride>(){

            @Override
            public void completed(AutoTopicCreationOverride autoTopicCreationOverride) {
                future.complete(autoTopicCreationOverride);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void removeAutoTopicCreation(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeAutoTopicCreationAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeAutoTopicCreationAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "autoTopicCreation");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void setAutoSubscriptionCreation(String namespace, AutoSubscriptionCreationOverride autoSubscriptionCreationOverride) throws PulsarAdminException {
        this.sync(() -> this.setAutoSubscriptionCreationAsync(namespace, autoSubscriptionCreationOverride));
    }

    @Override
    public CompletableFuture<Void> setAutoSubscriptionCreationAsync(String namespace, AutoSubscriptionCreationOverride autoSubscriptionCreationOverride) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "autoSubscriptionCreation");
        return this.asyncPostRequest(path, Entity.entity(autoSubscriptionCreationOverride, "application/json"));
    }

    @Override
    public AutoSubscriptionCreationOverride getAutoSubscriptionCreation(String namespace) throws PulsarAdminException {
        return (AutoSubscriptionCreationOverride)this.sync(() -> this.getAutoSubscriptionCreationAsync(namespace));
    }

    @Override
    public CompletableFuture<AutoSubscriptionCreationOverride> getAutoSubscriptionCreationAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "autoSubscriptionCreation");
        final CompletableFuture<AutoSubscriptionCreationOverride> future = new CompletableFuture<AutoSubscriptionCreationOverride>();
        this.asyncGetRequest(path, new InvocationCallback<AutoSubscriptionCreationOverride>(){

            @Override
            public void completed(AutoSubscriptionCreationOverride autoSubscriptionCreation) {
                future.complete(autoSubscriptionCreation);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setSubscriptionTypesEnabled(String namespace, Set<SubscriptionType> subscriptionTypesEnabled) throws PulsarAdminException {
        this.sync(() -> this.setSubscriptionTypesEnabledAsync(namespace, subscriptionTypesEnabled));
    }

    @Override
    public CompletableFuture<Void> setSubscriptionTypesEnabledAsync(String namespace, Set<SubscriptionType> subscriptionTypes) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionTypesEnabled");
        return this.asyncPostRequest(path, Entity.entity(subscriptionTypes, "application/json"));
    }

    @Override
    public Set<SubscriptionType> getSubscriptionTypesEnabled(String namespace) throws PulsarAdminException {
        return (Set)this.sync(() -> this.getSubscriptionTypesEnabledAsync(namespace));
    }

    @Override
    public CompletableFuture<Set<SubscriptionType>> getSubscriptionTypesEnabledAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionTypesEnabled");
        final CompletableFuture<Set<SubscriptionType>> future = new CompletableFuture<Set<SubscriptionType>>();
        this.asyncGetRequest(path, new InvocationCallback<Set<SubscriptionType>>(){

            @Override
            public void completed(Set<SubscriptionType> subscriptionTypesEnabled) {
                future.complete(subscriptionTypesEnabled);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void removeSubscriptionTypesEnabled(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeSubscriptionTypesEnabledAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeSubscriptionTypesEnabledAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionTypesEnabled");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void removeAutoSubscriptionCreation(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeAutoSubscriptionCreationAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeAutoSubscriptionCreationAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "autoSubscriptionCreation");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(String namespace) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getBacklogQuotaMapAsync(namespace));
    }

    @Override
    public CompletableFuture<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>> getBacklogQuotaMapAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "backlogQuotaMap");
        final CompletableFuture<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>> future = new CompletableFuture<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>>(){

            @Override
            public void completed(Map<BacklogQuota.BacklogQuotaType, BacklogQuota> quotaMap) {
                future.complete(quotaMap);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setBacklogQuota(String namespace, BacklogQuota backlogQuota, BacklogQuota.BacklogQuotaType backlogQuotaType) throws PulsarAdminException {
        this.sync(() -> this.setBacklogQuotaAsync(namespace, backlogQuota, backlogQuotaType));
    }

    @Override
    public CompletableFuture<Void> setBacklogQuotaAsync(String namespace, BacklogQuota backlogQuota, BacklogQuota.BacklogQuotaType backlogQuotaType) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "backlogQuota");
        return this.asyncPostRequest(path.queryParam("backlogQuotaType", backlogQuotaType.toString()), Entity.entity(backlogQuota, "application/json"));
    }

    @Override
    public void removeBacklogQuota(String namespace, BacklogQuota.BacklogQuotaType backlogQuotaType) throws PulsarAdminException {
        this.sync(() -> this.removeBacklogQuotaAsync(namespace, backlogQuotaType));
    }

    @Override
    public void removeInactiveTopicPolicies(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeInactiveTopicPoliciesAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeInactiveTopicPoliciesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "inactiveTopicPolicies");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public CompletableFuture<Void> removeBacklogQuotaAsync(String namespace, BacklogQuota.BacklogQuotaType backlogQuotaType) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "backlogQuota").queryParam("backlogQuotaType", backlogQuotaType.toString());
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void removePersistence(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removePersistenceAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removePersistenceAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void setPersistence(String namespace, PersistencePolicies persistence) throws PulsarAdminException {
        this.sync(() -> this.setPersistenceAsync(namespace, persistence));
    }

    @Override
    public CompletableFuture<Void> setPersistenceAsync(String namespace, PersistencePolicies persistence) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence");
        return this.asyncPostRequest(path, Entity.entity(persistence, "application/json"));
    }

    @Override
    public void setBookieAffinityGroup(String namespace, BookieAffinityGroupData bookieAffinityGroup) throws PulsarAdminException {
        this.sync(() -> this.setBookieAffinityGroupAsync(namespace, bookieAffinityGroup));
    }

    @Override
    public CompletableFuture<Void> setBookieAffinityGroupAsync(String namespace, BookieAffinityGroupData bookieAffinityGroup) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence", "bookieAffinity");
        return this.asyncPostRequest(path, Entity.entity(bookieAffinityGroup, "application/json"));
    }

    @Override
    public void deleteBookieAffinityGroup(String namespace) throws PulsarAdminException {
        this.sync(() -> this.deleteBookieAffinityGroupAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> deleteBookieAffinityGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence", "bookieAffinity");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public BookieAffinityGroupData getBookieAffinityGroup(String namespace) throws PulsarAdminException {
        return (BookieAffinityGroupData)this.sync(() -> this.getBookieAffinityGroupAsync(namespace));
    }

    @Override
    public CompletableFuture<BookieAffinityGroupData> getBookieAffinityGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence", "bookieAffinity");
        final CompletableFuture<BookieAffinityGroupData> future = new CompletableFuture<BookieAffinityGroupData>();
        this.asyncGetRequest(path, new InvocationCallback<BookieAffinityGroupData>(){

            @Override
            public void completed(BookieAffinityGroupData bookieAffinityGroupData) {
                future.complete(bookieAffinityGroupData);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public PersistencePolicies getPersistence(String namespace) throws PulsarAdminException {
        return (PersistencePolicies)this.sync(() -> this.getPersistenceAsync(namespace));
    }

    @Override
    public CompletableFuture<PersistencePolicies> getPersistenceAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence");
        final CompletableFuture<PersistencePolicies> future = new CompletableFuture<PersistencePolicies>();
        this.asyncGetRequest(path, new InvocationCallback<PersistencePolicies>(){

            @Override
            public void completed(PersistencePolicies persistencePolicies) {
                future.complete(persistencePolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setRetention(String namespace, RetentionPolicies retention) throws PulsarAdminException {
        this.sync(() -> this.setRetentionAsync(namespace, retention));
    }

    @Override
    public CompletableFuture<Void> setRetentionAsync(String namespace, RetentionPolicies retention) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "retention");
        return this.asyncPostRequest(path, Entity.entity(retention, "application/json"));
    }

    @Override
    public void removeRetention(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeRetentionAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeRetentionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "retention");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public RetentionPolicies getRetention(String namespace) throws PulsarAdminException {
        return (RetentionPolicies)this.sync(() -> this.getRetentionAsync(namespace));
    }

    @Override
    public CompletableFuture<RetentionPolicies> getRetentionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "retention");
        final CompletableFuture<RetentionPolicies> future = new CompletableFuture<RetentionPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<RetentionPolicies>(){

            @Override
            public void completed(RetentionPolicies retentionPolicies) {
                future.complete(retentionPolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void unload(String namespace) throws PulsarAdminException {
        this.sync(() -> this.unloadAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> unloadAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "unload");
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public String getReplicationConfigVersion(String namespace) throws PulsarAdminException {
        return (String)this.sync(() -> this.getReplicationConfigVersionAsync(namespace));
    }

    @Override
    public CompletableFuture<String> getReplicationConfigVersionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "configversion");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String s) {
                future.complete(s);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void unloadNamespaceBundle(String namespace, String bundle) throws PulsarAdminException {
        this.sync(() -> this.unloadNamespaceBundleAsync(namespace, bundle));
    }

    @Override
    public CompletableFuture<Void> unloadNamespaceBundleAsync(String namespace, String bundle) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "unload");
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void splitNamespaceBundle(String namespace, String bundle, boolean unloadSplitBundles, String splitAlgorithmName) throws PulsarAdminException {
        this.sync(() -> this.splitNamespaceBundleAsync(namespace, bundle, unloadSplitBundles, splitAlgorithmName));
    }

    @Override
    public CompletableFuture<Void> splitNamespaceBundleAsync(String namespace, String bundle, boolean unloadSplitBundles, String splitAlgorithmName) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "split").queryParam("unload", Boolean.toString(unloadSplitBundles)).queryParam("splitAlgorithmName", splitAlgorithmName);
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void setPublishRate(String namespace, PublishRate publishMsgRate) throws PulsarAdminException {
        this.sync(() -> this.setPublishRateAsync(namespace, publishMsgRate));
    }

    @Override
    public void removePublishRate(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removePublishRateAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> setPublishRateAsync(String namespace, PublishRate publishMsgRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "publishRate");
        return this.asyncPostRequest(path, Entity.entity(publishMsgRate, "application/json"));
    }

    @Override
    public CompletableFuture<Void> removePublishRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "publishRate");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public PublishRate getPublishRate(String namespace) throws PulsarAdminException {
        return (PublishRate)this.sync(() -> this.getPublishRateAsync(namespace));
    }

    @Override
    public CompletableFuture<PublishRate> getPublishRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "publishRate");
        final CompletableFuture<PublishRate> future = new CompletableFuture<PublishRate>();
        this.asyncGetRequest(path, new InvocationCallback<PublishRate>(){

            @Override
            public void completed(PublishRate publishRate) {
                future.complete(publishRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void removeDispatchRate(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeDispatchRateAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "dispatchRate");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void setDispatchRate(String namespace, DispatchRate dispatchRate) throws PulsarAdminException {
        this.sync(() -> this.setDispatchRateAsync(namespace, dispatchRate));
    }

    @Override
    public CompletableFuture<Void> setDispatchRateAsync(String namespace, DispatchRate dispatchRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "dispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    @Override
    public DispatchRate getDispatchRate(String namespace) throws PulsarAdminException {
        return (DispatchRate)this.sync(() -> this.getDispatchRateAsync(namespace));
    }

    @Override
    public CompletableFuture<DispatchRate> getDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "dispatchRate");
        final CompletableFuture<DispatchRate> future = new CompletableFuture<DispatchRate>();
        this.asyncGetRequest(path, new InvocationCallback<DispatchRate>(){

            @Override
            public void completed(DispatchRate dispatchRate) {
                future.complete(dispatchRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setSubscribeRate(String namespace, SubscribeRate subscribeRate) throws PulsarAdminException {
        this.sync(() -> this.setSubscribeRateAsync(namespace, subscribeRate));
    }

    @Override
    public CompletableFuture<Void> setSubscribeRateAsync(String namespace, SubscribeRate subscribeRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscribeRate");
        return this.asyncPostRequest(path, Entity.entity(subscribeRate, "application/json"));
    }

    @Override
    public void removeSubscribeRate(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeSubscribeRateAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeSubscribeRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscribeRate");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public SubscribeRate getSubscribeRate(String namespace) throws PulsarAdminException {
        return (SubscribeRate)this.sync(() -> this.getSubscribeRateAsync(namespace));
    }

    @Override
    public CompletableFuture<SubscribeRate> getSubscribeRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscribeRate");
        final CompletableFuture<SubscribeRate> future = new CompletableFuture<SubscribeRate>();
        this.asyncGetRequest(path, new InvocationCallback<SubscribeRate>(){

            @Override
            public void completed(SubscribeRate subscribeRate) {
                future.complete(subscribeRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void removeSubscriptionDispatchRate(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeSubscriptionDispatchRateAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeSubscriptionDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionDispatchRate");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void setSubscriptionDispatchRate(String namespace, DispatchRate dispatchRate) throws PulsarAdminException {
        this.sync(() -> this.setSubscriptionDispatchRateAsync(namespace, dispatchRate));
    }

    @Override
    public CompletableFuture<Void> setSubscriptionDispatchRateAsync(String namespace, DispatchRate dispatchRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionDispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    @Override
    public DispatchRate getSubscriptionDispatchRate(String namespace) throws PulsarAdminException {
        return (DispatchRate)this.sync(() -> this.getSubscriptionDispatchRateAsync(namespace));
    }

    @Override
    public CompletableFuture<DispatchRate> getSubscriptionDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionDispatchRate");
        final CompletableFuture<DispatchRate> future = new CompletableFuture<DispatchRate>();
        this.asyncGetRequest(path, new InvocationCallback<DispatchRate>(){

            @Override
            public void completed(DispatchRate dispatchRate) {
                future.complete(dispatchRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setReplicatorDispatchRate(String namespace, DispatchRate dispatchRate) throws PulsarAdminException {
        this.sync(() -> this.setReplicatorDispatchRateAsync(namespace, dispatchRate));
    }

    @Override
    public CompletableFuture<Void> setReplicatorDispatchRateAsync(String namespace, DispatchRate dispatchRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "replicatorDispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    @Override
    public void removeReplicatorDispatchRate(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeReplicatorDispatchRateAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeReplicatorDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "replicatorDispatchRate");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public DispatchRate getReplicatorDispatchRate(String namespace) throws PulsarAdminException {
        return (DispatchRate)this.sync(() -> this.getReplicatorDispatchRateAsync(namespace));
    }

    @Override
    public CompletableFuture<DispatchRate> getReplicatorDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "replicatorDispatchRate");
        final CompletableFuture<DispatchRate> future = new CompletableFuture<DispatchRate>();
        this.asyncGetRequest(path, new InvocationCallback<DispatchRate>(){

            @Override
            public void completed(DispatchRate dispatchRate) {
                future.complete(dispatchRate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void clearNamespaceBacklog(String namespace) throws PulsarAdminException {
        this.sync(() -> this.clearNamespaceBacklogAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> clearNamespaceBacklogAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "clearBacklog");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void clearNamespaceBacklogForSubscription(String namespace, String subscription) throws PulsarAdminException {
        this.sync(() -> this.clearNamespaceBacklogForSubscriptionAsync(namespace, subscription));
    }

    @Override
    public CompletableFuture<Void> clearNamespaceBacklogForSubscriptionAsync(String namespace, String subscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "clearBacklog", subscription);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void clearNamespaceBundleBacklog(String namespace, String bundle) throws PulsarAdminException {
        this.sync(() -> this.clearNamespaceBundleBacklogAsync(namespace, bundle));
    }

    @Override
    public CompletableFuture<Void> clearNamespaceBundleBacklogAsync(String namespace, String bundle) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "clearBacklog");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void clearNamespaceBundleBacklogForSubscription(String namespace, String bundle, String subscription) throws PulsarAdminException {
        this.sync(() -> this.clearNamespaceBundleBacklogForSubscriptionAsync(namespace, bundle, subscription));
    }

    @Override
    public CompletableFuture<Void> clearNamespaceBundleBacklogForSubscriptionAsync(String namespace, String bundle, String subscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "clearBacklog", subscription);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void unsubscribeNamespace(String namespace, String subscription) throws PulsarAdminException {
        this.sync(() -> this.unsubscribeNamespaceAsync(namespace, subscription));
    }

    @Override
    public CompletableFuture<Void> unsubscribeNamespaceAsync(String namespace, String subscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "unsubscribe", subscription);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void unsubscribeNamespaceBundle(String namespace, String bundle, String subscription) throws PulsarAdminException {
        this.sync(() -> this.unsubscribeNamespaceBundleAsync(namespace, bundle, subscription));
    }

    @Override
    public CompletableFuture<Void> unsubscribeNamespaceBundleAsync(String namespace, String bundle, String subscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "unsubscribe", subscription);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void setSubscriptionAuthMode(String namespace, SubscriptionAuthMode subscriptionAuthMode) throws PulsarAdminException {
        this.sync(() -> this.setSubscriptionAuthModeAsync(namespace, subscriptionAuthMode));
    }

    @Override
    public CompletableFuture<Void> setSubscriptionAuthModeAsync(String namespace, SubscriptionAuthMode subscriptionAuthMode) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionAuthMode");
        return this.asyncPostRequest(path, Entity.entity(subscriptionAuthMode, "application/json"));
    }

    @Override
    public SubscriptionAuthMode getSubscriptionAuthMode(String namespace) throws PulsarAdminException {
        return (SubscriptionAuthMode)((Object)this.sync(() -> this.getSubscriptionAuthModeAsync(namespace)));
    }

    @Override
    public CompletableFuture<SubscriptionAuthMode> getSubscriptionAuthModeAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionAuthMode");
        final CompletableFuture<SubscriptionAuthMode> future = new CompletableFuture<SubscriptionAuthMode>();
        this.asyncGetRequest(path, new InvocationCallback<SubscriptionAuthMode>(){

            @Override
            public void completed(SubscriptionAuthMode subscriptionAuthMode) {
                future.complete(subscriptionAuthMode);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setEncryptionRequiredStatus(String namespace, boolean encryptionRequired) throws PulsarAdminException {
        this.sync(() -> this.setEncryptionRequiredStatusAsync(namespace, encryptionRequired));
    }

    @Override
    public CompletableFuture<Void> setEncryptionRequiredStatusAsync(String namespace, boolean encryptionRequired) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "encryptionRequired");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(encryptionRequired), "application/json"));
    }

    @Override
    public Boolean getEncryptionRequiredStatus(String namespace) throws PulsarAdminException {
        return (Boolean)this.sync(() -> this.getEncryptionRequiredStatusAsync(namespace));
    }

    @Override
    public CompletableFuture<Boolean> getEncryptionRequiredStatusAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "encryptionRequired");
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.asyncGetRequest(path, new InvocationCallback<Boolean>(){

            @Override
            public void completed(Boolean enabled) {
                future.complete(enabled);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public DelayedDeliveryPolicies getDelayedDelivery(String namespace) throws PulsarAdminException {
        return (DelayedDeliveryPolicies)this.sync(() -> this.getDelayedDeliveryAsync(namespace));
    }

    @Override
    public CompletableFuture<DelayedDeliveryPolicies> getDelayedDeliveryAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "delayedDelivery");
        final CompletableFuture<DelayedDeliveryPolicies> future = new CompletableFuture<DelayedDeliveryPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<DelayedDeliveryPolicies>(){

            @Override
            public void completed(DelayedDeliveryPolicies delayedDeliveryPolicies) {
                future.complete(delayedDeliveryPolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setDelayedDeliveryMessages(String namespace, DelayedDeliveryPolicies delayedDeliveryPolicies) throws PulsarAdminException {
        this.sync(() -> this.setDelayedDeliveryMessagesAsync(namespace, delayedDeliveryPolicies));
    }

    @Override
    public CompletableFuture<Void> setDelayedDeliveryMessagesAsync(String namespace, DelayedDeliveryPolicies delayedDeliveryPolicies) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "delayedDelivery");
        return this.asyncPostRequest(path, Entity.entity(delayedDeliveryPolicies, "application/json"));
    }

    @Override
    public void removeDelayedDeliveryMessages(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeDelayedDeliveryMessagesAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeDelayedDeliveryMessagesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "delayedDelivery");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public InactiveTopicPolicies getInactiveTopicPolicies(String namespace) throws PulsarAdminException {
        return (InactiveTopicPolicies)this.sync(() -> this.getInactiveTopicPoliciesAsync(namespace));
    }

    @Override
    public CompletableFuture<InactiveTopicPolicies> getInactiveTopicPoliciesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "inactiveTopicPolicies");
        final CompletableFuture<InactiveTopicPolicies> future = new CompletableFuture<InactiveTopicPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<InactiveTopicPolicies>(){

            @Override
            public void completed(InactiveTopicPolicies inactiveTopicPolicies) {
                future.complete(inactiveTopicPolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setInactiveTopicPolicies(String namespace, InactiveTopicPolicies inactiveTopicPolicies) throws PulsarAdminException {
        this.sync(() -> this.setInactiveTopicPoliciesAsync(namespace, inactiveTopicPolicies));
    }

    @Override
    public CompletableFuture<Void> setInactiveTopicPoliciesAsync(String namespace, InactiveTopicPolicies inactiveTopicPolicies) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "inactiveTopicPolicies");
        return this.asyncPostRequest(path, Entity.entity(inactiveTopicPolicies, "application/json"));
    }

    @Override
    public Integer getDeduplicationSnapshotInterval(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getDeduplicationSnapshotIntervalAsync(namespace));
    }

    @Override
    public CompletableFuture<Integer> getDeduplicationSnapshotIntervalAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "deduplicationSnapshotInterval");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer interval) {
                future.complete(interval);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setDeduplicationSnapshotInterval(String namespace, Integer interval) throws PulsarAdminException {
        this.sync(() -> this.setDeduplicationSnapshotIntervalAsync(namespace, interval));
    }

    @Override
    public CompletableFuture<Void> setDeduplicationSnapshotIntervalAsync(String namespace, Integer interval) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "deduplicationSnapshotInterval");
        return this.asyncPostRequest(path, Entity.entity(interval, "application/json"));
    }

    @Override
    public void removeDeduplicationSnapshotInterval(String namespace) throws PulsarAdminException {
        this.setDeduplicationSnapshotInterval(namespace, null);
    }

    @Override
    public CompletableFuture<Void> removeDeduplicationSnapshotIntervalAsync(String namespace) {
        return this.setDeduplicationSnapshotIntervalAsync(namespace, null);
    }

    @Override
    public Integer getMaxSubscriptionsPerTopic(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxSubscriptionsPerTopicAsync(namespace));
    }

    @Override
    public CompletableFuture<Integer> getMaxSubscriptionsPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxSubscriptionsPerTopic");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer maxSubscriptionsPerTopic) {
                future.complete(maxSubscriptionsPerTopic);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setMaxSubscriptionsPerTopic(String namespace, int maxSubscriptionsPerTopic) throws PulsarAdminException {
        this.sync(() -> this.setMaxSubscriptionsPerTopicAsync(namespace, maxSubscriptionsPerTopic));
    }

    @Override
    public CompletableFuture<Void> setMaxSubscriptionsPerTopicAsync(String namespace, int maxSubscriptionsPerTopic) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxSubscriptionsPerTopic");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxSubscriptionsPerTopic), "application/json"));
    }

    @Override
    public void removeMaxSubscriptionsPerTopic(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeMaxSubscriptionsPerTopicAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeMaxSubscriptionsPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxSubscriptionsPerTopic");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Integer getMaxProducersPerTopic(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxProducersPerTopicAsync(namespace));
    }

    @Override
    public CompletableFuture<Integer> getMaxProducersPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxProducersPerTopic");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer max) {
                future.complete(max);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setMaxProducersPerTopic(String namespace, int maxProducersPerTopic) throws PulsarAdminException {
        this.sync(() -> this.setMaxProducersPerTopicAsync(namespace, maxProducersPerTopic));
    }

    @Override
    public CompletableFuture<Void> setMaxProducersPerTopicAsync(String namespace, int maxProducersPerTopic) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxProducersPerTopic");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxProducersPerTopic), "application/json"));
    }

    @Override
    public void removeMaxProducersPerTopic(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeMaxProducersPerTopicAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeMaxProducersPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxProducersPerTopic");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Integer getMaxConsumersPerTopic(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxConsumersPerTopicAsync(namespace));
    }

    @Override
    public CompletableFuture<Integer> getMaxConsumersPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerTopic");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer max) {
                future.complete(max);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setMaxConsumersPerTopic(String namespace, int maxConsumersPerTopic) throws PulsarAdminException {
        this.sync(() -> this.setMaxConsumersPerTopicAsync(namespace, maxConsumersPerTopic));
    }

    @Override
    public CompletableFuture<Void> setMaxConsumersPerTopicAsync(String namespace, int maxConsumersPerTopic) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerTopic");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxConsumersPerTopic), "application/json"));
    }

    @Override
    public void removeMaxConsumersPerTopic(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeMaxConsumersPerTopicAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeMaxConsumersPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerTopic");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Integer getMaxConsumersPerSubscription(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxConsumersPerSubscriptionAsync(namespace));
    }

    @Override
    public CompletableFuture<Integer> getMaxConsumersPerSubscriptionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerSubscription");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer max) {
                future.complete(max);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setMaxConsumersPerSubscription(String namespace, int maxConsumersPerSubscription) throws PulsarAdminException {
        this.sync(() -> this.setMaxConsumersPerSubscriptionAsync(namespace, maxConsumersPerSubscription));
    }

    @Override
    public CompletableFuture<Void> setMaxConsumersPerSubscriptionAsync(String namespace, int maxConsumersPerSubscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerSubscription");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxConsumersPerSubscription), "application/json"));
    }

    @Override
    public void removeMaxConsumersPerSubscription(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeMaxConsumersPerSubscriptionAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeMaxConsumersPerSubscriptionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerSubscription");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Integer getMaxUnackedMessagesPerConsumer(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxUnackedMessagesPerConsumerAsync(namespace));
    }

    @Override
    public CompletableFuture<Integer> getMaxUnackedMessagesPerConsumerAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerConsumer");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer max) {
                future.complete(max);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setMaxUnackedMessagesPerConsumer(String namespace, int maxUnackedMessagesPerConsumer) throws PulsarAdminException {
        this.sync(() -> this.setMaxUnackedMessagesPerConsumerAsync(namespace, maxUnackedMessagesPerConsumer));
    }

    @Override
    public CompletableFuture<Void> setMaxUnackedMessagesPerConsumerAsync(String namespace, int maxUnackedMessagesPerConsumer) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerConsumer");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxUnackedMessagesPerConsumer), "application/json"));
    }

    @Override
    public void removeMaxUnackedMessagesPerConsumer(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeMaxUnackedMessagesPerConsumerAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeMaxUnackedMessagesPerConsumerAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerConsumer");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Integer getMaxUnackedMessagesPerSubscription(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxUnackedMessagesPerSubscriptionAsync(namespace));
    }

    @Override
    public CompletableFuture<Integer> getMaxUnackedMessagesPerSubscriptionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerSubscription");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer max) {
                future.complete(max);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setMaxUnackedMessagesPerSubscription(String namespace, int maxUnackedMessagesPerSubscription) throws PulsarAdminException {
        this.sync(() -> this.setMaxUnackedMessagesPerSubscriptionAsync(namespace, maxUnackedMessagesPerSubscription));
    }

    @Override
    public CompletableFuture<Void> setMaxUnackedMessagesPerSubscriptionAsync(String namespace, int maxUnackedMessagesPerSubscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerSubscription");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxUnackedMessagesPerSubscription), "application/json"));
    }

    @Override
    public void removeMaxUnackedMessagesPerSubscription(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeMaxUnackedMessagesPerSubscriptionAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeMaxUnackedMessagesPerSubscriptionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerSubscription");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Long getCompactionThreshold(String namespace) throws PulsarAdminException {
        return (Long)this.sync(() -> this.getCompactionThresholdAsync(namespace));
    }

    @Override
    public CompletableFuture<Long> getCompactionThresholdAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "compactionThreshold");
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.asyncGetRequest(path, new InvocationCallback<Long>(){

            @Override
            public void completed(Long threshold) {
                future.complete(threshold);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setCompactionThreshold(String namespace, long compactionThreshold) throws PulsarAdminException {
        this.sync(() -> this.setCompactionThresholdAsync(namespace, compactionThreshold));
    }

    @Override
    public CompletableFuture<Void> setCompactionThresholdAsync(String namespace, long compactionThreshold) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "compactionThreshold");
        return this.asyncPutRequest(path, Entity.entity(Long.valueOf(compactionThreshold), "application/json"));
    }

    @Override
    public void removeCompactionThreshold(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeCompactionThresholdAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeCompactionThresholdAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "compactionThreshold");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public long getOffloadThreshold(String namespace) throws PulsarAdminException {
        return (Long)this.sync(() -> this.getOffloadThresholdAsync(namespace));
    }

    @Override
    public CompletableFuture<Long> getOffloadThresholdAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadThreshold");
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.asyncGetRequest(path, new InvocationCallback<Long>(){

            @Override
            public void completed(Long threshold) {
                future.complete(threshold);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setOffloadThreshold(String namespace, long offloadThreshold) throws PulsarAdminException {
        this.sync(() -> this.setOffloadThresholdAsync(namespace, offloadThreshold));
    }

    @Override
    public CompletableFuture<Void> setOffloadThresholdAsync(String namespace, long offloadThreshold) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadThreshold");
        return this.asyncPutRequest(path, Entity.entity(Long.valueOf(offloadThreshold), "application/json"));
    }

    @Override
    public Long getOffloadDeleteLagMs(String namespace) throws PulsarAdminException {
        return (Long)this.sync(() -> this.getOffloadDeleteLagMsAsync(namespace));
    }

    @Override
    public CompletableFuture<Long> getOffloadDeleteLagMsAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadDeletionLagMs");
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.asyncGetRequest(path, new InvocationCallback<Long>(){

            @Override
            public void completed(Long lag) {
                future.complete(lag);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setOffloadDeleteLag(String namespace, long lag, TimeUnit unit) throws PulsarAdminException {
        this.sync(() -> this.setOffloadDeleteLagAsync(namespace, lag, unit));
    }

    @Override
    public CompletableFuture<Void> setOffloadDeleteLagAsync(String namespace, long lag, TimeUnit unit) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadDeletionLagMs");
        return this.asyncPutRequest(path, Entity.entity(Long.valueOf(TimeUnit.MILLISECONDS.convert(lag, unit)), "application/json"));
    }

    @Override
    public void clearOffloadDeleteLag(String namespace) throws PulsarAdminException {
        this.sync(() -> this.clearOffloadDeleteLagAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> clearOffloadDeleteLagAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadDeletionLagMs");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public SchemaAutoUpdateCompatibilityStrategy getSchemaAutoUpdateCompatibilityStrategy(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "schemaAutoUpdateCompatibilityStrategy");
            return this.request(path).get(SchemaAutoUpdateCompatibilityStrategy.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void setSchemaAutoUpdateCompatibilityStrategy(String namespace, SchemaAutoUpdateCompatibilityStrategy strategy) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "schemaAutoUpdateCompatibilityStrategy");
            this.request(path).put(Entity.entity(strategy, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public boolean getSchemaValidationEnforced(String namespace) throws PulsarAdminException {
        return this.getSchemaValidationEnforced(namespace, false);
    }

    @Override
    public CompletableFuture<Boolean> getSchemaValidationEnforcedAsync(String namespace) {
        return this.getSchemaValidationEnforcedAsync(namespace, false);
    }

    @Override
    public boolean getSchemaValidationEnforced(String namespace, boolean applied) throws PulsarAdminException {
        return (Boolean)this.sync(() -> this.getSchemaValidationEnforcedAsync(namespace, applied));
    }

    @Override
    public CompletableFuture<Boolean> getSchemaValidationEnforcedAsync(String namespace, boolean applied) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "schemaValidationEnforced");
        path = path.queryParam("applied", applied);
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.asyncGetRequest(path, new InvocationCallback<Boolean>(){

            @Override
            public void completed(Boolean enforced) {
                future.complete(enforced);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setSchemaValidationEnforced(String namespace, boolean schemaValidationEnforced) throws PulsarAdminException {
        this.sync(() -> this.setSchemaValidationEnforcedAsync(namespace, schemaValidationEnforced));
    }

    @Override
    public CompletableFuture<Void> setSchemaValidationEnforcedAsync(String namespace, boolean schemaValidationEnforced) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "schemaValidationEnforced");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(schemaValidationEnforced), "application/json"));
    }

    @Override
    public SchemaCompatibilityStrategy getSchemaCompatibilityStrategy(String namespace) throws PulsarAdminException {
        return (SchemaCompatibilityStrategy)((Object)this.sync(() -> this.getSchemaCompatibilityStrategyAsync(namespace)));
    }

    @Override
    public CompletableFuture<SchemaCompatibilityStrategy> getSchemaCompatibilityStrategyAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "schemaCompatibilityStrategy");
        final CompletableFuture<SchemaCompatibilityStrategy> future = new CompletableFuture<SchemaCompatibilityStrategy>();
        this.asyncGetRequest(path, new InvocationCallback<SchemaCompatibilityStrategy>(){

            @Override
            public void completed(SchemaCompatibilityStrategy schemaCompatibilityStrategy) {
                future.complete(schemaCompatibilityStrategy);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setSchemaCompatibilityStrategy(String namespace, SchemaCompatibilityStrategy strategy) throws PulsarAdminException {
        this.sync(() -> this.setSchemaCompatibilityStrategyAsync(namespace, strategy));
    }

    @Override
    public CompletableFuture<Void> setSchemaCompatibilityStrategyAsync(String namespace, SchemaCompatibilityStrategy strategy) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "schemaCompatibilityStrategy");
        return this.asyncPutRequest(path, Entity.entity(strategy, "application/json"));
    }

    @Override
    public boolean getIsAllowAutoUpdateSchema(String namespace) throws PulsarAdminException {
        return (Boolean)this.sync(() -> this.getIsAllowAutoUpdateSchemaAsync(namespace));
    }

    @Override
    public CompletableFuture<Boolean> getIsAllowAutoUpdateSchemaAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "isAllowAutoUpdateSchema");
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.asyncGetRequest(path, new InvocationCallback<Boolean>(){

            @Override
            public void completed(Boolean allowAutoUpdate) {
                future.complete(allowAutoUpdate);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setIsAllowAutoUpdateSchema(String namespace, boolean isAllowAutoUpdateSchema) throws PulsarAdminException {
        this.sync(() -> this.setIsAllowAutoUpdateSchemaAsync(namespace, isAllowAutoUpdateSchema));
    }

    @Override
    public CompletableFuture<Void> setIsAllowAutoUpdateSchemaAsync(String namespace, boolean isAllowAutoUpdateSchema) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "isAllowAutoUpdateSchema");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(isAllowAutoUpdateSchema), "application/json"));
    }

    @Override
    public void setOffloadPolicies(String namespace, OffloadPolicies offloadPolicies) throws PulsarAdminException {
        this.sync(() -> this.setOffloadPoliciesAsync(namespace, offloadPolicies));
    }

    @Override
    public void removeOffloadPolicies(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeOffloadPoliciesAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> setOffloadPoliciesAsync(String namespace, OffloadPolicies offloadPolicies) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadPolicies");
        return this.asyncPostRequest(path, Entity.entity(offloadPolicies, "application/json"));
    }

    @Override
    public CompletableFuture<Void> removeOffloadPoliciesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "removeOffloadPolicies");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public OffloadPolicies getOffloadPolicies(String namespace) throws PulsarAdminException {
        return (OffloadPolicies)this.sync(() -> this.getOffloadPoliciesAsync(namespace));
    }

    @Override
    public CompletableFuture<OffloadPolicies> getOffloadPoliciesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadPolicies");
        final CompletableFuture<OffloadPolicies> future = new CompletableFuture<OffloadPolicies>();
        this.asyncGetRequest(path, new InvocationCallback<OffloadPoliciesImpl>(){

            @Override
            public void completed(OffloadPoliciesImpl offloadPolicies) {
                future.complete(offloadPolicies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public int getMaxTopicsPerNamespace(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxTopicsPerNamespaceAsync(namespace));
    }

    @Override
    public CompletableFuture<Integer> getMaxTopicsPerNamespaceAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxTopicsPerNamespace");
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.asyncGetRequest(path, new InvocationCallback<Integer>(){

            @Override
            public void completed(Integer maxTopicsPerNamespace) {
                future.complete(maxTopicsPerNamespace);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void setMaxTopicsPerNamespace(String namespace, int maxTopicsPerNamespace) throws PulsarAdminException {
        this.sync(() -> this.setMaxTopicsPerNamespaceAsync(namespace, maxTopicsPerNamespace));
    }

    @Override
    public CompletableFuture<Void> setMaxTopicsPerNamespaceAsync(String namespace, int maxTopicsPerNamespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxTopicsPerNamespace");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxTopicsPerNamespace), "application/json"));
    }

    @Override
    public void removeMaxTopicsPerNamespace(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeMaxTopicsPerNamespaceAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeMaxTopicsPerNamespaceAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxTopicsPerNamespace");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public CompletableFuture<Void> setPropertyAsync(String namespace, String key, String value) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "property", key, value);
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void setProperty(String namespace, String key, String value) throws PulsarAdminException {
        this.sync(() -> this.setPropertyAsync(namespace, key, value));
    }

    @Override
    public CompletableFuture<Void> setPropertiesAsync(String namespace, Map<String, String> properties) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "properties");
        return this.asyncPutRequest(path, Entity.entity(properties, "application/json"));
    }

    @Override
    public void setProperties(String namespace, Map<String, String> properties) throws PulsarAdminException {
        this.sync(() -> this.setPropertiesAsync(namespace, properties));
    }

    @Override
    public String getNamespaceResourceGroup(String namespace) throws PulsarAdminException {
        return (String)this.sync(() -> this.getNamespaceResourceGroupAsync(namespace));
    }

    @Override
    public CompletableFuture<String> getPropertyAsync(String namespace, String key) {
        NamespaceName ns = NamespaceName.get(namespace);
        final CompletableFuture<String> future = new CompletableFuture<String>();
        WebTarget path = this.namespacePath(ns, "property", key);
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String value) {
                future.complete(StringUtils.isEmpty(value) ? null : value);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public String getProperty(String namespace, String key) throws PulsarAdminException {
        return (String)this.sync(() -> this.getPropertyAsync(namespace, key));
    }

    @Override
    public CompletableFuture<Map<String, String>> getPropertiesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        final CompletableFuture<Map<String, String>> future = new CompletableFuture<Map<String, String>>();
        WebTarget path = this.namespacePath(ns, "properties");
        this.asyncGetRequest(path, new InvocationCallback<Map<String, String>>(){

            @Override
            public void completed(Map<String, String> value) {
                future.complete(value);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<String> getNamespaceResourceGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "resourcegroup");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String rgName) {
                future.complete(rgName);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public Map<String, String> getProperties(String namespace) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getPropertiesAsync(namespace));
    }

    @Override
    public void setNamespaceResourceGroup(String namespace, String resourcegroupname) throws PulsarAdminException {
        this.sync(() -> this.setNamespaceResourceGroupAsync(namespace, resourcegroupname));
    }

    @Override
    public CompletableFuture<String> removePropertyAsync(String namespace, String key) {
        NamespaceName ns = NamespaceName.get(namespace);
        final CompletableFuture<String> future = new CompletableFuture<String>();
        WebTarget path = this.namespacePath(ns, "property", key);
        this.asyncDeleteRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String value) {
                future.complete(StringUtils.isEmpty(value) ? null : value);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(NamespacesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public String removeProperty(String namespace, String key) throws PulsarAdminException {
        return (String)this.sync(() -> this.removePropertyAsync(namespace, key));
    }

    @Override
    public CompletableFuture<Void> setNamespaceResourceGroupAsync(String namespace, String resourcegroupname) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "resourcegroup", resourcegroupname);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void removeNamespaceResourceGroup(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeNamespaceResourceGroupAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> clearPropertiesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        CompletableFuture future = new CompletableFuture();
        WebTarget path = this.namespacePath(ns, "properties");
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void clearProperties(String namespace) throws PulsarAdminException {
        this.sync(() -> this.clearPropertiesAsync(namespace));
    }

    @Override
    public CompletableFuture<Void> removeNamespaceResourceGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "resourcegroup");
        return this.asyncDeleteRequest(path);
    }

    private WebTarget namespacePath(NamespaceName namespace, String ... parts) {
        WebTarget base = namespace.isV2() ? this.adminV2Namespaces : this.adminNamespaces;
        WebTarget namespacePath = base.path(namespace.toString());
        namespacePath = WebTargets.addParts(namespacePath, parts);
        return namespacePath;
    }
}

