/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.pulsar.broker.BookKeeperClientFactoryImpl;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.SizeUnit;
import org.apache.pulsar.client.internal.PropertiesUtils;
import org.apache.pulsar.compaction.TwoPhaseCompactor;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.shade.com.beust.jcommander.JCommander;
import org.apache.pulsar.shade.com.beust.jcommander.Parameter;
import org.apache.pulsar.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.pulsar.shade.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.shade.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookKeeper;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.CmdGenerateDocs;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.AdvertisedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactorTool {
    private static final Logger log = LoggerFactory.getLogger(CompactorTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        AdvertisedListener internalListener;
        Arguments arguments = new Arguments();
        JCommander jcommander = new JCommander(arguments);
        jcommander.setProgramName("PulsarTopicCompactor");
        jcommander.parse(args);
        if (arguments.help) {
            jcommander.usage();
            System.exit(-1);
        }
        if (arguments.generateDocs) {
            CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
            cmd.addCommand("compact-topic", arguments);
            cmd.run(null);
            System.exit(-1);
        }
        if (StringUtils.isBlank(arguments.brokerConfigFile)) {
            jcommander.usage();
            throw new IllegalArgumentException("Need to specify a configuration file for broker");
        }
        log.info(String.format("read configuration file %s", arguments.brokerConfigFile));
        ServiceConfiguration brokerConfig = (ServiceConfiguration)PulsarConfigurationLoader.create(arguments.brokerConfigFile, ServiceConfiguration.class);
        if (StringUtils.isBlank(brokerConfig.getMetadataStoreUrl())) {
            throw new IllegalArgumentException(String.format("Need to specify `metadataStoreUrl` or `zookeeperServers` in configuration file \nor specify configuration file path from command line.\nnow configuration file path is=[%s]\n", arguments.brokerConfigFile));
        }
        ClientBuilder clientBuilder = PulsarClient.builder().memoryLimit(0L, SizeUnit.BYTES);
        clientBuilder.loadConf(PropertiesUtils.filterAndMapProperties(brokerConfig.getProperties(), "brokerClient_"));
        if (StringUtils.isNotBlank(brokerConfig.getBrokerClientAuthenticationPlugin())) {
            clientBuilder.authentication(brokerConfig.getBrokerClientAuthenticationPlugin(), brokerConfig.getBrokerClientAuthenticationParameters());
        }
        if ((internalListener = ServiceConfigurationUtils.getInternalListener(brokerConfig, "pulsar+ssl")).getBrokerServiceUrlTls() != null) {
            log.info("Found a TLS-based advertised listener in configuration file. \nWill connect pulsar use TLS.");
            clientBuilder.serviceUrl(internalListener.getBrokerServiceUrlTls().toString()).allowTlsInsecureConnection(brokerConfig.isTlsAllowInsecureConnection()).tlsTrustCertsFilePath(brokerConfig.getTlsCertificateFilePath());
        } else {
            internalListener = ServiceConfigurationUtils.getInternalListener(brokerConfig, "pulsar");
            clientBuilder.serviceUrl(internalListener.getBrokerServiceUrl().toString());
        }
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("compaction-%d").setDaemon(true).build());
        try {
            OrderedScheduler executor = OrderedScheduler.newSchedulerBuilder().build();
            try {
                MetadataStoreExtended store = MetadataStoreExtended.create(brokerConfig.getMetadataStoreUrl(), MetadataStoreConfig.builder().sessionTimeoutMillis((int)brokerConfig.getMetadataStoreSessionTimeoutMillis()).build());
                try {
                    BookKeeperClientFactoryImpl bkClientFactory = new BookKeeperClientFactoryImpl();
                    try {
                        EventLoopGroup eventLoopGroup = EventLoopUtil.newEventLoopGroup(1, false, new DefaultThreadFactory("compactor-io"));
                        try {
                            BookKeeper bk = bkClientFactory.create(brokerConfig, store, eventLoopGroup, Optional.empty(), null);
                            try {
                                PulsarClient pulsar = clientBuilder.build();
                                try {
                                    TwoPhaseCompactor compactor = new TwoPhaseCompactor(brokerConfig, pulsar, bk, scheduler);
                                    long ledgerId = compactor.compact(arguments.topic).get();
                                    log.info("Compaction of topic {} complete. Compacted to ledger {}", (Object)arguments.topic, (Object)ledgerId);
                                }
                                finally {
                                    if (Collections.singletonList(pulsar).get(0) != null) {
                                        pulsar.close();
                                    }
                                }
                            }
                            finally {
                                if (Collections.singletonList(bk).get(0) != null) {
                                    bk.close();
                                }
                            }
                        }
                        finally {
                            if (Collections.singletonList(eventLoopGroup).get(0) != null) {
                                eventLoopGroup.shutdownGracefully();
                            }
                        }
                    }
                    finally {
                        if (Collections.singletonList(bkClientFactory).get(0) != null) {
                            bkClientFactory.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(store).get(0) != null) {
                        store.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(executor).get(0) != null) {
                    executor.shutdownNow();
                }
            }
        }
        finally {
            if (Collections.singletonList(scheduler).get(0) != null) {
                scheduler.shutdownNow();
            }
        }
    }

    private static class Arguments {
        @Parameter(names={"-c", "--broker-conf"}, description="Configuration file for Broker")
        private String brokerConfigFile = Paths.get("", new String[0]).toAbsolutePath().normalize().toString() + "/conf/broker.conf";
        @Parameter(names={"-t", "--topic"}, description="Topic to compact", required=true)
        private String topic;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;
        @Parameter(names={"-g", "--generate-docs"}, description="Generate docs")
        private boolean generateDocs = false;

        private Arguments() {
        }
    }
}

