/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import org.apache.pulsar.functions.worker.Worker;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.shade.com.beust.jcommander.JCommander;
import org.apache.pulsar.shade.com.beust.jcommander.Parameter;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.CmdGenerateDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionWorkerStarter {
    private static final Logger log = LoggerFactory.getLogger(FunctionWorkerStarter.class);

    public static void main(String[] args) throws Exception {
        WorkerArguments workerArguments = new WorkerArguments();
        JCommander commander = new JCommander(workerArguments);
        commander.setProgramName("FunctionWorkerStarter");
        commander.parse(args);
        if (workerArguments.help) {
            commander.usage();
            System.exit(1);
            return;
        }
        if (workerArguments.generateDocs) {
            CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
            cmd.addCommand("functions-worker", workerArguments);
            cmd.run(null);
            return;
        }
        WorkerConfig workerConfig = StringUtils.isBlank(workerArguments.configFile) ? new WorkerConfig() : WorkerConfig.load(workerArguments.configFile);
        Worker worker = new Worker(workerConfig);
        try {
            worker.start();
        }
        catch (Throwable th) {
            log.error("Encountered error in function worker.", th);
            worker.stop();
            Runtime.getRuntime().halt(1);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Stopping function worker service...");
            worker.stop();
        }));
    }

    private static class WorkerArguments {
        @Parameter(names={"-c", "--conf"}, description="Configuration File for Function Worker")
        private String configFile;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;
        @Parameter(names={"-g", "--generate-docs"}, description="Generate docs")
        private boolean generateDocs = false;

        private WorkerArguments() {
        }
    }
}

