/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pulsar.metadata.api.MetadataSerde;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.DataFormats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieServiceInfoSerde
implements MetadataSerde<BookieServiceInfo> {
    private static final Logger log = LoggerFactory.getLogger(BookieServiceInfoSerde.class);
    static final BookieServiceInfoSerde INSTANCE = new BookieServiceInfoSerde();

    private BookieServiceInfoSerde() {
    }

    @Override
    public byte[] serialize(String path, BookieServiceInfo bookieServiceInfo) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("serialize BookieServiceInfo {}", (Object)bookieServiceInfo);
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            DataFormats.BookieServiceInfoFormat.Builder builder = DataFormats.BookieServiceInfoFormat.newBuilder();
            List bsiEndpoints = bookieServiceInfo.getEndpoints().stream().map(e -> DataFormats.BookieServiceInfoFormat.Endpoint.newBuilder().setId(e.getId()).setPort(e.getPort()).setHost(e.getHost()).setProtocol(e.getProtocol()).addAllAuth(e.getAuth()).addAllExtensions(e.getExtensions()).build()).collect(Collectors.toList());
            builder.addAllEndpoints(bsiEndpoints);
            builder.putAllProperties(bookieServiceInfo.getProperties());
            builder.build().writeTo(os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    @Override
    public BookieServiceInfo deserialize(String path, byte[] content, Stat stat) throws IOException {
        return null;
    }
}

