/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.bookkeeper.AbstractHierarchicalLedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.shade.org.apache.zookeeper.AsyncCallback;

class LegacyHierarchicalLedgerManager
extends AbstractHierarchicalLedgerManager {
    LegacyHierarchicalLedgerManager(MetadataStore store, ScheduledExecutorService scheduler, String ledgerRootPath) {
        super(store, scheduler, ledgerRootPath);
    }

    @Override
    protected String getLedgerParentNodeRegex() {
        return "\\d{2}";
    }

    public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> processor, AsyncCallback.VoidCallback finalCb, Object context, int successRc, int failureRc) {
        this.asyncProcessLevelNodes(this.ledgerRootPath, (l1Node, cb1) -> {
            if (!this.isLedgerParentNode((String)l1Node)) {
                cb1.processResult(successRc, null, context);
                return;
            }
            String l1NodePath = this.ledgerRootPath + "/" + l1Node;
            this.asyncProcessLevelNodes(l1NodePath, (l2Node, cb2) -> {
                String l2NodePath = this.ledgerRootPath + "/" + l1Node + "/" + l2Node;
                this.asyncProcessLedgersInSingleNode(l2NodePath, processor, cb2, context, successRc, failureRc);
            }, cb1, context, successRc, failureRc);
        }, finalCb, context, successRc, failureRc);
    }
}

