/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.bookkeeper.PulsarLayoutManager;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerAuditorManager;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerIdGenerator;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerManager;
import org.apache.pulsar.metadata.bookkeeper.PulsarLedgerUnderreplicationManager;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.AbstractZkLedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LayoutManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerAuditorManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.replication.ReplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarLedgerManagerFactory
implements LedgerManagerFactory {
    private static final Logger log = LoggerFactory.getLogger(PulsarLedgerManagerFactory.class);
    private static final int CUR_VERSION = 1;
    private AbstractConfiguration conf;
    private MetadataStoreExtended store;
    private String ledgerRootPath;

    @Override
    public LedgerManagerFactory initialize(AbstractConfiguration conf, LayoutManager layoutManager, int factoryVersion) throws IOException {
        Preconditions.checkArgument(layoutManager instanceof PulsarLayoutManager);
        PulsarLayoutManager pulsarLayoutManager = (PulsarLayoutManager)layoutManager;
        if (1 != factoryVersion) {
            throw new IOException("Incompatible layout version found : " + factoryVersion);
        }
        this.conf = conf;
        this.store = pulsarLayoutManager.getStore();
        this.ledgerRootPath = pulsarLayoutManager.getLedgersRootPath();
        return this;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public LedgerIdGenerator newLedgerIdGenerator() {
        return new PulsarLedgerIdGenerator(this.store, this.ledgerRootPath);
    }

    @Override
    public LedgerManager newLedgerManager() {
        return new PulsarLedgerManager(this.store, this.ledgerRootPath);
    }

    @Override
    public LedgerUnderreplicationManager newLedgerUnderreplicationManager() throws ReplicationException.CompatibilityException {
        return new PulsarLedgerUnderreplicationManager(this.conf, this.store, this.ledgerRootPath);
    }

    @Override
    public LedgerAuditorManager newLedgerAuditorManager() throws IOException, InterruptedException {
        return new PulsarLedgerAuditorManager(this.store, this.ledgerRootPath);
    }

    @Override
    public void format(AbstractConfiguration<?> abstractConfiguration, LayoutManager layoutManager) throws InterruptedException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateAndNukeExistingCluster(AbstractConfiguration<?> conf, LayoutManager layoutManager) throws InterruptedException, IOException {
        PulsarLedgerManager ledgerManager = new PulsarLedgerManager(this.store, this.ledgerRootPath);
        try {
            List<String> ledgersRootPathChildrenList = this.store.getChildren(this.ledgerRootPath).join();
            for (String ledgersRootPathChildren : ledgersRootPathChildrenList) {
                if (AbstractZkLedgerManager.isSpecialZnode(ledgersRootPathChildren) || ledgerManager.isLedgerParentNode(ledgersRootPathChildren)) continue;
                log.error("Found unexpected node : {} under ledgersRootPath : {} so exiting nuke operation", (Object)ledgersRootPathChildren, (Object)this.ledgerRootPath);
                boolean bl = false;
                return bl;
            }
            this.format(conf, layoutManager);
            for (String ledgersRootPathChildren : this.store.getChildren(this.ledgerRootPath).join()) {
                if (!AbstractZkLedgerManager.isSpecialZnode(ledgersRootPathChildren)) {
                    log.error("Found unexpected node : {} under ledgersRootPath : {} so exiting nuke operation", (Object)ledgersRootPathChildren, (Object)this.ledgerRootPath);
                    boolean bl = false;
                    return bl;
                }
                this.store.deleteRecursive(this.ledgerRootPath + "/" + ledgersRootPathChildren).join();
            }
            this.store.deleteRecursive(this.ledgerRootPath).join();
            log.info("Successfully nuked existing cluster");
            boolean bl = true;
            return bl;
        }
        finally {
            if (Collections.singletonList(ledgerManager).get(0) != null) {
                ledgerManager.close();
            }
        }
    }
}

