/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractByteCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractIterator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.BitMixer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.BufferAllocationException;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ByteBufferVisualizer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ByteContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ByteLookupContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ByteSet;
import org.apache.pulsar.shade.com.carrotsearch.hppc.HashContainers;
import org.apache.pulsar.shade.com.carrotsearch.hppc.HashOrderMixing;
import org.apache.pulsar.shade.com.carrotsearch.hppc.HashOrderMixingStrategy;
import org.apache.pulsar.shade.com.carrotsearch.hppc.Preallocable;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.ByteCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.BytePredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.ByteProcedure;

public class ByteHashSet
extends AbstractByteCollection
implements ByteLookupContainer,
ByteSet,
Preallocable,
Cloneable {
    public byte[] keys;
    protected int assigned;
    protected int mask;
    protected int keyMixer;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public ByteHashSet() {
        this(4, 0.75);
    }

    public ByteHashSet(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ByteHashSet(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public ByteHashSet(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ByteHashSet(ByteContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public boolean add(byte key) {
        byte existing;
        if (key == 0) {
            assert (this.keys[this.mask + 1] == 0);
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        byte[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        ++this.assigned;
        return true;
    }

    public final int addAll(byte ... elements) {
        this.ensureCapacity(elements.length);
        int count = 0;
        for (byte e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public int addAll(ByteContainer container) {
        this.ensureCapacity(container.size());
        return this.addAll((Iterable<? extends ByteCursor>)container);
    }

    public int addAll(Iterable<? extends ByteCursor> iterable) {
        int count = 0;
        for (ByteCursor byteCursor : iterable) {
            if (!this.add(byteCursor.value)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public byte[] toArray() {
        byte[] cloned = new byte[this.size()];
        int j = 0;
        if (this.hasEmptyKey) {
            cloned[j++] = 0;
        }
        byte[] keys = this.keys;
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            byte existing = keys[slot];
            if (existing == 0) continue;
            cloned[j++] = existing;
        }
        return cloned;
    }

    public boolean remove(byte key) {
        byte existing;
        if (key == 0) {
            boolean hadEmptyKey = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return hadEmptyKey;
        }
        byte[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int removeAll(byte key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public int removeAll(BytePredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply((byte)0)) {
            this.hasEmptyKey = false;
        }
        byte[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            byte existing = keys[slot];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public boolean contains(byte key) {
        byte existing;
        if (key == 0) {
            return this.hasEmptyKey;
        }
        byte[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (byte)0);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            byte[] prevKeys = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys);
            }
        }
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        byte[] keys = this.keys;
        for (int slot = this.mask; slot >= 0; --slot) {
            byte existing = keys[slot];
            if (existing == 0) continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.sameKeys((ByteSet)this.getClass().cast(obj));
    }

    private boolean sameKeys(ByteSet other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (ByteCursor c : other) {
            if (this.contains(c.value)) continue;
            return false;
        }
        return true;
    }

    public ByteHashSet clone() {
        try {
            ByteHashSet cloned = (ByteHashSet)super.clone();
            cloned.keys = (byte[])this.keys.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<ByteCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ByteProcedure> T forEach(T procedure) {
        if (this.hasEmptyKey) {
            procedure.apply((byte)0);
        }
        byte[] keys = this.keys;
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            byte existing = keys[slot];
            if (existing == 0) continue;
            procedure.apply(existing);
        }
        return procedure;
    }

    @Override
    public <T extends BytePredicate> T forEach(T predicate) {
        byte existing;
        if (this.hasEmptyKey && !predicate.apply((byte)0)) {
            return predicate;
        }
        byte[] keys = this.keys;
        int max = this.mask;
        for (int slot = 0; slot <= max && ((existing = keys[slot]) == 0 || predicate.apply(existing)); ++slot) {
        }
        return predicate;
    }

    public static ByteHashSet from(byte ... elements) {
        ByteHashSet set = new ByteHashSet(elements.length);
        set.addAll(elements);
        return set;
    }

    protected int hashKey(byte key) {
        assert (key != 0);
        return BitMixer.mix(key, this.keyMixer);
    }

    public int indexOf(byte key) {
        byte existing;
        int mask = this.mask;
        if (key == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        byte[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    public byte indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.keys[index];
    }

    public byte indexReplace(int index, byte equivalentKey) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        assert (equivalentKey == this.keys[index]);
        byte previousValue = this.keys[index];
        this.keys[index] = equivalentKey;
        return previousValue;
    }

    public void indexInsert(int index, byte key) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == 0) {
            assert (index == this.mask + 1);
            assert (this.keys[index] == 0);
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == 0);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key);
            } else {
                this.keys[index] = key;
            }
            ++this.assigned;
        }
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return ByteBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(byte[] fromKeys) {
        assert (HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        byte[] keys = this.keys;
        int mask = this.mask;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            byte existing = fromKeys[i];
            if (existing == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        byte[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new byte[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.keys == null ? 0 : this.size(), arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, byte pendingKey) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0 && pendingKey != 0);
        byte[] prevKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        byte existing;
        byte[] keys = this.keys;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        --this.assigned;
    }

    protected final class EntryIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ByteHashSet.this.mask + 1;
            this.slot = -1;
            this.cursor = new ByteCursor();
        }

        @Override
        protected ByteCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    byte existing = ByteHashSet.this.keys[this.slot];
                    if (existing != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ByteHashSet.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }
}

