/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import org.apache.pulsar.shade.com.carrotsearch.hppc.BitMixer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.HashOrderMixing;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongByteHashMap;

public class LongByteScatterMap
extends LongByteHashMap {
    public LongByteScatterMap() {
        this(4);
    }

    public LongByteScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongByteScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(long key) {
        return BitMixer.mixPhi(key);
    }

    public static LongByteScatterMap from(long[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongByteScatterMap map = new LongByteScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

