/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.swagger.models.properties;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonAnyGetter;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonAnySetter;
import org.apache.pulsar.shade.io.swagger.models.Xml;
import org.apache.pulsar.shade.io.swagger.models.properties.Property;

public abstract class AbstractProperty
implements Property,
Cloneable {
    protected String name;
    protected String type;
    protected String format;
    protected Object example;
    protected Xml xml;
    protected boolean required;
    protected Integer position;
    protected String description;
    protected String title;
    protected Boolean readOnly;
    protected Boolean allowEmptyValue;
    protected String access;
    protected Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();

    @Override
    public Property rename(String newName) {
        try {
            Property newProperty = (Property)this.clone();
            newProperty.setName(newName);
            return newProperty;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("Clone is not supported!?");
        }
    }

    @Override
    public Property title(String title) {
        this.setTitle(title);
        return this;
    }

    @Override
    public Property description(String description) {
        this.setDescription(description);
        return this;
    }

    public Property readOnly() {
        this.setReadOnly(Boolean.TRUE);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractProperty)) {
            return false;
        }
        AbstractProperty that = (AbstractProperty)o;
        if (this.required != that.required) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.format != null ? !this.format.equals(that.format) : that.format != null) {
            return false;
        }
        if (this.example != null ? !this.example.equals(that.example) : that.example != null) {
            return false;
        }
        if (this.xml != null ? !this.xml.equals(that.xml) : that.xml != null) {
            return false;
        }
        if (this.position != null ? !this.position.equals(that.position) : that.position != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.allowEmptyValue != null ? !this.allowEmptyValue.equals(that.allowEmptyValue) : that.allowEmptyValue != null) {
            return false;
        }
        if (this.access != null ? !this.access.equals(that.access) : that.access != null) {
            return false;
        }
        return this.vendorExtensions != null ? this.vendorExtensions.equals(that.vendorExtensions) : that.vendorExtensions == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        result = 31 * result + (this.example != null ? this.example.hashCode() : 0);
        result = 31 * result + (this.xml != null ? this.xml.hashCode() : 0);
        result = 31 * result + (this.required ? 1 : 0);
        result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
        result = 31 * result + (this.allowEmptyValue != null ? this.allowEmptyValue.hashCode() : 0);
        result = 31 * result + (this.access != null ? this.access.hashCode() : 0);
        result = 31 * result + (this.vendorExtensions != null ? this.vendorExtensions.hashCode() : 0);
        return result;
    }

    public Property allowEmptyValue(Boolean allowEmptyValue) {
        this.setAllowEmptyValue(allowEmptyValue);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getExample() {
        return this.example;
    }

    @Override
    public void setExample(Object example) {
        this.example = example;
    }

    @Override
    public void setExample(String example) {
        this.setExample((Object)example);
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Integer position) {
        this.position = position;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public Xml getXml() {
        return this.xml;
    }

    @Override
    public void setXml(Xml xml) {
        this.xml = xml;
    }

    @Override
    public boolean getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(Boolean readOnly) {
        this.readOnly = Boolean.FALSE.equals(readOnly) ? null : readOnly;
    }

    @Override
    public void setDefault(String _default) {
    }

    @Override
    public String getAccess() {
        return this.access;
    }

    @Override
    public void setAccess(String access) {
        this.access = access;
    }

    @Override
    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    @Override
    public void setAllowEmptyValue(Boolean allowEmptyValue) {
        if (allowEmptyValue != null) {
            this.allowEmptyValue = allowEmptyValue;
        }
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String name, Object value) {
        if (name.startsWith("x-")) {
            this.vendorExtensions.put(name, value);
        }
    }

    public void setVendorExtensions(Map<String, Object> vendorExtensions) {
        this.vendorExtensions = vendorExtensions;
    }

    public void setVendorExtensionMap(Map<String, Object> vendorExtensionMap) {
        this.vendorExtensions.putAll(vendorExtensionMap);
    }
}

