/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.client.impl;

import java.util.Arrays;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.DigestType;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.OpenBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OpenBuilderBase
implements OpenBuilder {
    static final Logger LOG = LoggerFactory.getLogger(OpenBuilderBase.class);
    protected boolean recovery = false;
    protected long ledgerId = -2882382797L;
    protected byte[] password;
    protected DigestType digestType = DigestType.CRC32;

    @Override
    public OpenBuilder withLedgerId(long ledgerId) {
        this.ledgerId = ledgerId;
        return this;
    }

    @Override
    public OpenBuilder withRecovery(boolean recovery) {
        this.recovery = recovery;
        return this;
    }

    @Override
    public OpenBuilder withPassword(byte[] password) {
        this.password = Arrays.copyOf(password, password.length);
        return this;
    }

    @Override
    public OpenBuilder withDigestType(DigestType digestType) {
        this.digestType = digestType;
        return this;
    }

    protected int validate() {
        if (this.ledgerId < 0L) {
            LOG.error("invalid ledgerId {} < 0", (Object)this.ledgerId);
            return -25;
        }
        return 0;
    }
}

