/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.clients.impl.internal;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.impl.internal.api.RootRangeClient;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.StreamProperties;

public class StreamMetadataCache {
    private final RootRangeClient scClient;
    private final ConcurrentMap<Long, StreamProperties> streams;

    public StreamMetadataCache(RootRangeClient scClient) {
        this.scClient = scClient;
        this.streams = Maps.newConcurrentMap();
    }

    @VisibleForTesting
    ConcurrentMap<Long, StreamProperties> getStreams() {
        return this.streams;
    }

    CompletableFuture<StreamProperties> getStreamProperties(long streamId) {
        StreamProperties props = (StreamProperties)this.streams.get(streamId);
        if (null != props) {
            return FutureUtils.value(props);
        }
        return this.scClient.getStream(streamId).thenApply(propsReturned -> {
            this.streams.put(streamId, (StreamProperties)propsReturned);
            return propsReturned;
        });
    }

    boolean putStreamProperties(long streamId, StreamProperties props) {
        return null == this.streams.putIfAbsent(streamId, props);
    }
}

