/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.clients.utils;

import io.grpc.ManagedChannelBuilder;
import io.grpc.inprocess.InProcessChannelBuilder;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.resolver.NameResolverFactoryProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.resolver.ServiceNameResolverProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcChannels {
    private static final Logger log = LoggerFactory.getLogger(GrpcChannels.class);
    private static final String BACKEND_INPROCESS = "inprocess";
    private static final String BK_REG_NAME_RESOLVER_PROVIDER = "org.apache.pulsar.shade.org.apache.bookkeeper.grpc.resolver.BKRegistrationNameResolverProvider";

    private GrpcChannels() {
    }

    public static ManagedChannelBuilder createChannelBuilder(String serviceUri, StorageClientSettings settings) {
        ManagedChannelBuilder builder;
        ServiceURI uri = ServiceURI.create(serviceUri);
        if (uri.getServiceInfos().length > 0 && uri.getServiceInfos()[0].equals(BACKEND_INPROCESS)) {
            String serviceName = uri.getServiceHosts()[0];
            builder = InProcessChannelBuilder.forName((String)serviceName).directExecutor();
        } else if (null == uri.getServiceName() || "bk".equals(uri.getServiceName())) {
            builder = ManagedChannelBuilder.forTarget((String)serviceUri).nameResolverFactory(new ServiceNameResolverProvider().toFactory());
        } else {
            NameResolverFactoryProvider provider;
            try {
                provider = ReflectionUtils.newInstance(BK_REG_NAME_RESOLVER_PROVIDER, NameResolverFactoryProvider.class);
            }
            catch (RuntimeException re) {
                log.error("It seems that you don't have `bk-grpc-name-resolver` in your class path. Please make sure you include it as your application's dependency.");
                throw re;
            }
            builder = ManagedChannelBuilder.forTarget((String)serviceUri).nameResolverFactory(provider.toFactory());
        }
        if (settings.usePlaintext()) {
            builder = builder.usePlaintext();
        }
        return builder;
    }
}

