/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.grpc.proxy;

import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;

class ProxyCall<ReqT, RespT> {
    private final RequestProxy serverCallListener;
    private final ResponseProxy clientCallListener;

    ProxyCall(ServerCall<ReqT, RespT> serverCall, ClientCall<ReqT, RespT> clientCall) {
        this.serverCallListener = new RequestProxy(clientCall);
        this.clientCallListener = new ResponseProxy(serverCall);
    }

    public RequestProxy getServerCallListener() {
        return this.serverCallListener;
    }

    public ResponseProxy getClientCallListener() {
        return this.clientCallListener;
    }

    private class ResponseProxy
    extends ClientCall.Listener<RespT> {
        private final ServerCall<?, RespT> serverCall;
        private boolean needToRequest;

        public ResponseProxy(ServerCall<?, RespT> serverCall) {
            this.serverCall = serverCall;
        }

        public void onHeaders(Metadata headers) {
            this.serverCall.sendHeaders(headers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(RespT message) {
            this.serverCall.sendMessage(message);
            ResponseProxy responseProxy = this;
            synchronized (responseProxy) {
                if (this.serverCall.isReady()) {
                    ProxyCall.this.serverCallListener.clientCall.request(1);
                } else {
                    this.needToRequest = true;
                }
            }
        }

        public void onClose(Status status, Metadata trailers) {
            this.serverCall.close(status, trailers);
        }

        public void onReady() {
            ProxyCall.this.serverCallListener.onClientReady();
        }

        synchronized void onServerReady() {
            if (this.needToRequest) {
                ProxyCall.this.serverCallListener.clientCall.request(1);
                this.needToRequest = false;
            }
        }
    }

    private class RequestProxy
    extends ServerCall.Listener<ReqT> {
        private final ClientCall<ReqT, ?> clientCall;
        private boolean needToRequest;

        public RequestProxy(ClientCall<ReqT, ?> clientCall) {
            this.clientCall = clientCall;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(ReqT message) {
            this.clientCall.sendMessage(message);
            RequestProxy requestProxy = this;
            synchronized (requestProxy) {
                if (this.clientCall.isReady()) {
                    ProxyCall.this.clientCallListener.serverCall.request(1);
                } else {
                    this.needToRequest = true;
                }
            }
        }

        public void onHalfClose() {
            this.clientCall.halfClose();
        }

        public void onCancel() {
            this.clientCall.cancel("Server cancelled", null);
        }

        public void onReady() {
            ProxyCall.this.clientCallListener.onServerReady();
        }

        synchronized void onClientReady() {
            if (this.needToRequest) {
                ProxyCall.this.clientCallListener.serverCall.request(1);
                this.needToRequest = false;
            }
        }
    }
}

