/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.util;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.shade.com.google.common.util.concurrent.ForwardingExecutorService;

public class BoundedExecutorService
extends ForwardingExecutorService {
    private final BlockingQueue<Runnable> queue;
    private final ThreadPoolExecutor thread;
    private final int maxTasksInQueue;

    public BoundedExecutorService(ThreadPoolExecutor thread, int maxTasksInQueue) {
        this.queue = thread.getQueue();
        this.thread = thread;
        this.maxTasksInQueue = maxTasksInQueue;
    }

    @Override
    protected ExecutorService delegate() {
        return this.thread;
    }

    private void checkQueue(int numberOfTasks) {
        if (this.maxTasksInQueue > 0 && this.queue.size() + numberOfTasks > this.maxTasksInQueue) {
            throw new RejectedExecutionException("Queue at limit of " + this.maxTasksInQueue + " items");
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.checkQueue(tasks.size());
        return super.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.checkQueue(tasks.size());
        return super.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.checkQueue(tasks.size());
        return super.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.checkQueue(tasks.size());
        return super.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.checkQueue(1);
        super.execute(command);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.checkQueue(1);
        return super.submit(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.checkQueue(1);
        return super.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.checkQueue(1);
        return super.submit(task, result);
    }
}

