/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.meta;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Version;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Versioned;
import org.apache.pulsar.shade.org.apache.zookeeper.AsyncCallback;

public interface LedgerManager
extends Closeable {
    public CompletableFuture<Versioned<LedgerMetadata>> createLedgerMetadata(long var1, LedgerMetadata var3);

    public CompletableFuture<Void> removeLedgerMetadata(long var1, Version var3);

    public CompletableFuture<Versioned<LedgerMetadata>> readLedgerMetadata(long var1);

    public CompletableFuture<Versioned<LedgerMetadata>> writeLedgerMetadata(long var1, LedgerMetadata var3, Version var4);

    public void registerLedgerMetadataListener(long var1, BookkeeperInternalCallbacks.LedgerMetadataListener var3);

    public void unregisterLedgerMetadataListener(long var1, BookkeeperInternalCallbacks.LedgerMetadataListener var3);

    public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> var1, AsyncCallback.VoidCallback var2, Object var3, int var4, int var5);

    public LedgerRangeIterator getLedgerRanges(long var1);

    public static interface LedgerRangeIterator {
        public boolean hasNext() throws IOException;

        public LedgerRange next() throws IOException;
    }

    public static class LedgerRange {
        private final SortedSet<Long> ledgers;

        public LedgerRange(Set<Long> ledgers) {
            this.ledgers = new TreeSet<Long>(ledgers);
        }

        public int size() {
            return this.ledgers.size();
        }

        public Long start() {
            return this.ledgers.first();
        }

        public Long end() {
            return this.ledgers.last();
        }

        public Set<Long> getLedgers() {
            return this.ledgers;
        }
    }
}

