/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.meta;

import java.io.IOException;
import java.util.List;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.shade.org.apache.commons.lang.StringUtils;
import org.apache.pulsar.shade.org.apache.zookeeper.AsyncCallback;
import org.apache.pulsar.shade.org.apache.zookeeper.CreateMode;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;
import org.apache.pulsar.shade.org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkLedgerIdGenerator
implements LedgerIdGenerator {
    static final Logger LOG = LoggerFactory.getLogger(ZkLedgerIdGenerator.class);
    static final String LEDGER_ID_GEN_PREFIX = "ID-";
    final ZooKeeper zk;
    final String ledgerPrefix;
    final List<ACL> zkAcls;

    public ZkLedgerIdGenerator(ZooKeeper zk, String ledgersPath, String idGenZnodeName, List<ACL> zkAcls) {
        this.zk = zk;
        this.ledgerPrefix = ZkLedgerIdGenerator.createLedgerPrefix(ledgersPath, idGenZnodeName);
        this.zkAcls = zkAcls;
    }

    public static String createLedgerPrefix(String ledgersPath, String idGenZnodeName) {
        String ledgerIdGenPath = null;
        ledgerIdGenPath = StringUtils.isBlank(idGenZnodeName) ? ledgersPath : ledgersPath + "/" + idGenZnodeName;
        return ledgerIdGenPath + "/" + LEDGER_ID_GEN_PREFIX;
    }

    @Override
    public void generateLedgerId(BookkeeperInternalCallbacks.GenericCallback<Long> cb) {
        ZkLedgerIdGenerator.generateLedgerIdImpl(cb, this.zk, this.ledgerPrefix, this.zkAcls);
    }

    public static void generateLedgerIdImpl(final BookkeeperInternalCallbacks.GenericCallback<Long> cb, final ZooKeeper zk, final String ledgerPrefix, List<ACL> zkAcls) {
        ZkUtils.asyncCreateFullPathOptimistic(zk, ledgerPrefix, new byte[0], zkAcls, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx, final String idPathName) {
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("Could not generate new ledger id", (Throwable)KeeperException.create(KeeperException.Code.get(rc), path));
                    cb.operationComplete(-9, null);
                    return;
                }
                try {
                    long ledgerId = ZkLedgerIdGenerator.getLedgerIdFromGenPath(idPathName, ledgerPrefix);
                    if (ledgerId < 0L || ledgerId >= Integer.MAX_VALUE) {
                        cb.operationComplete(-106, null);
                    } else {
                        cb.operationComplete(0, ledgerId);
                    }
                }
                catch (IOException e) {
                    LOG.error("Could not extract ledger-id from id gen path:" + path, (Throwable)e);
                    cb.operationComplete(-9, null);
                    return;
                }
                zk.delete(idPathName, -1, new AsyncCallback.VoidCallback(){

                    @Override
                    public void processResult(int rc, String path, Object ctx) {
                        if (rc != KeeperException.Code.OK.intValue()) {
                            LOG.warn("Exception during deleting znode for id generation : ", (Throwable)KeeperException.create(KeeperException.Code.get(rc), path));
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("Deleting znode for id generation : {}", (Object)idPathName);
                        }
                    }
                }, null);
            }
        }, null);
    }

    private static long getLedgerIdFromGenPath(String nodeName, String ledgerPrefix) throws IOException {
        long ledgerId;
        try {
            String[] parts = nodeName.split(ledgerPrefix);
            ledgerId = Long.parseLong(parts[parts.length - 1]);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        return ledgerId;
    }

    @Override
    public void close() throws IOException {
    }
}

