/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.proto;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.com.google.protobuf.ByteString;
import org.apache.pulsar.shade.io.netty.channel.Channel;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Bookie;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.PacketProcessorBaseV3;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.AvailabilityOfEntriesOfLedger;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetListOfEntriesOfLedgerProcessorV3
extends PacketProcessorBaseV3
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(GetListOfEntriesOfLedgerProcessorV3.class);
    protected final BookkeeperProtocol.GetListOfEntriesOfLedgerRequest getListOfEntriesOfLedgerRequest;
    protected final long ledgerId;

    public GetListOfEntriesOfLedgerProcessorV3(BookkeeperProtocol.Request request, Channel channel, BookieRequestProcessor requestProcessor) {
        super(request, channel, requestProcessor);
        this.getListOfEntriesOfLedgerRequest = request.getGetListOfEntriesOfLedgerRequest();
        this.ledgerId = this.getListOfEntriesOfLedgerRequest.getLedgerId();
    }

    private BookkeeperProtocol.GetListOfEntriesOfLedgerResponse getListOfEntriesOfLedgerResponse() {
        long startTimeNanos = MathUtils.nowInNano();
        BookkeeperProtocol.GetListOfEntriesOfLedgerResponse.Builder getListOfEntriesOfLedgerResponse = BookkeeperProtocol.GetListOfEntriesOfLedgerResponse.newBuilder();
        getListOfEntriesOfLedgerResponse.setLedgerId(this.ledgerId);
        if (!this.isVersionCompatible()) {
            getListOfEntriesOfLedgerResponse.setStatus(BookkeeperProtocol.StatusCode.EBADVERSION);
            this.requestProcessor.getRequestStats().getGetListOfEntriesOfLedgerStats().registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            return getListOfEntriesOfLedgerResponse.build();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received new getListOfEntriesOfLedger request: {}", (Object)this.request);
        }
        BookkeeperProtocol.StatusCode status = BookkeeperProtocol.StatusCode.EOK;
        AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedger = null;
        try {
            availabilityOfEntriesOfLedger = new AvailabilityOfEntriesOfLedger(this.requestProcessor.bookie.getListOfEntriesOfLedger(this.ledgerId));
            getListOfEntriesOfLedgerResponse.setAvailabilityOfEntriesOfLedger(ByteString.copyFrom(availabilityOfEntriesOfLedger.serializeStateOfEntriesOfLedger()));
        }
        catch (Bookie.NoLedgerException e) {
            status = BookkeeperProtocol.StatusCode.ENOLEDGER;
            LOG.error("No ledger found while performing getListOfEntriesOfLedger from ledger: {}", (Object)this.ledgerId, (Object)e);
        }
        catch (IOException e) {
            status = BookkeeperProtocol.StatusCode.EIO;
            LOG.error("IOException while performing getListOfEntriesOfLedger from ledger: {}", (Object)this.ledgerId);
        }
        if (status == BookkeeperProtocol.StatusCode.EOK) {
            this.requestProcessor.getRequestStats().getListOfEntriesOfLedgerStats.registerSuccessfulEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
        } else {
            this.requestProcessor.getRequestStats().getListOfEntriesOfLedgerStats.registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
        }
        getListOfEntriesOfLedgerResponse.setStatus(status);
        return getListOfEntriesOfLedgerResponse.build();
    }

    @Override
    public void safeRun() {
        BookkeeperProtocol.GetListOfEntriesOfLedgerResponse listOfEntriesOfLedgerResponse = this.getListOfEntriesOfLedgerResponse();
        BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder().setHeader(this.getHeader()).setStatus(listOfEntriesOfLedgerResponse.getStatus()).setGetListOfEntriesOfLedgerResponse(listOfEntriesOfLedgerResponse);
        BookkeeperProtocol.Response resp = response.build();
        this.sendResponse(listOfEntriesOfLedgerResponse.getStatus(), resp, this.requestProcessor.getRequestStats().getListOfEntriesOfLedgerRequestStats);
    }
}

