/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.statelib.impl.mvcc.op.proto;

import java.util.Arrays;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.OpType;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.RangeOp;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.options.RangeOption;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.RangeRequest;

public class ProtoRangeOpImpl
implements RangeOp<byte[], byte[]>,
RangeOption<byte[]> {
    private static final Recycler<ProtoRangeOpImpl> RECYCLER = new Recycler<ProtoRangeOpImpl>(){

        @Override
        protected ProtoRangeOpImpl newObject(Recycler.Handle<ProtoRangeOpImpl> handle) {
            return new ProtoRangeOpImpl(handle);
        }
    };
    private final Recycler.Handle<ProtoRangeOpImpl> recyclerHandle;
    private RangeRequest req;
    private byte[] key;
    private byte[] endKey;

    public static ProtoRangeOpImpl newRangeOp(RangeRequest request) {
        ProtoRangeOpImpl op = RECYCLER.get();
        op.setCommand(request);
        return op;
    }

    void reset() {
        this.req = null;
        this.key = null;
        this.endKey = null;
    }

    void setCommand(RangeRequest request) {
        this.req = request;
    }

    @Override
    public void close() {
        this.reset();
        this.recyclerHandle.recycle(this);
    }

    @Override
    public byte[] key() {
        if (null != this.key) {
            return this.key;
        }
        this.key = (byte[])(null == this.req.getKey() ? null : this.req.getKey().toByteArray());
        return this.key;
    }

    @Override
    public RangeOption<byte[]> option() {
        return this;
    }

    @Override
    public byte[] endKey() {
        if (null != this.endKey) {
            return this.endKey;
        }
        this.endKey = (byte[])(null == this.req.getRangeEnd() || 0 == this.req.getRangeEnd().size() || 1 == this.req.getRangeEnd().size() && this.req.getRangeEnd().byteAt(0) == 0 ? null : this.req.getRangeEnd().toByteArray());
        return this.endKey;
    }

    @Override
    public long limit() {
        return this.req.getLimit();
    }

    @Override
    public long minModRev() {
        return this.req.getMinModRevision();
    }

    @Override
    public long maxModRev() {
        return this.req.getMaxModRevision();
    }

    @Override
    public long minCreateRev() {
        return this.req.getMinCreateRevision();
    }

    @Override
    public long maxCreateRev() {
        return this.req.getMaxCreateRevision();
    }

    @Override
    public boolean keysOnly() {
        return false;
    }

    @Override
    public boolean countOnly() {
        return this.req.getCountOnly();
    }

    @Override
    public OpType type() {
        return OpType.RANGE;
    }

    public ProtoRangeOpImpl(Recycler.Handle<ProtoRangeOpImpl> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public String toString() {
        return "ProtoRangeOpImpl(req=" + this.req + ", key=" + Arrays.toString(this.key) + ", endKey=" + Arrays.toString(this.endKey) + ")";
    }
}

