/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.pulsar.shade.org.apache.bookkeeper.statelib.api.checkpoint.CheckpointStore;
import org.apache.pulsar.shade.org.apache.bookkeeper.statelib.api.exceptions.StateStoreException;
import org.apache.pulsar.shade.org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint.CheckpointFile;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.store.CheckpointMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksdbRestoreTask {
    private static final Logger log = LoggerFactory.getLogger(RocksdbRestoreTask.class);
    private final String dbName;
    private final File checkpointDir;
    private final CheckpointStore checkpointStore;
    private final String dbPrefix;

    public RocksdbRestoreTask(String dbName, File checkpointDir, CheckpointStore checkpointStore) {
        this.dbName = dbName;
        this.checkpointDir = checkpointDir;
        this.checkpointStore = checkpointStore;
        this.dbPrefix = String.format("%s", dbName);
    }

    public void restore(String checkpointId, CheckpointMetadata metadata) throws StateStoreException {
        File checkpointedDir = new File(this.checkpointDir, checkpointId);
        try {
            if (!checkpointedDir.exists()) {
                Files.createDirectories(Paths.get(checkpointedDir.getAbsolutePath(), new String[0]), new FileAttribute[0]);
            }
            List<CheckpointFile> files = this.getCheckpointFiles(checkpointedDir, metadata);
            this.copyFilesFromRemote(checkpointId, files);
        }
        catch (IOException ioe) {
            log.error("Failed to restore checkpoint {} to local directory {}", new Object[]{checkpointId, checkpointedDir, ioe});
            throw new StateStoreException("Failed to restore checkpoint " + checkpointId + " to local directory " + checkpointedDir, ioe);
        }
    }

    protected List<CheckpointFile> getCheckpointFiles(File checkpointedDir, CheckpointMetadata metadata) {
        return CheckpointFile.list(checkpointedDir, metadata);
    }

    private void copyFilesFromRemote(String checkpointId, List<CheckpointFile> remoteFiles) throws IOException {
        for (CheckpointFile file : remoteFiles) {
            file.copyFromRemote(this.checkpointStore, this.dbPrefix, checkpointId);
        }
    }
}

