/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.service;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.impl.internal.api.StorageServerClientManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.shade.org.apache.bookkeeper.statelib.api.mvcc.MVCCAsyncStore;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.IncrementRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.IncrementResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.PutRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.PutResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.RangeRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.RangeResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.ResponseHeader;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.RoutingHeader;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.TxnRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.TxnResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.CreateNamespaceRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.CreateNamespaceResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.CreateStreamRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.CreateStreamResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.DeleteNamespaceRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.DeleteNamespaceResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.DeleteStreamRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.DeleteStreamResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.GetActiveRangesRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.GetActiveRangesResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.GetNamespaceRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.GetNamespaceResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.GetStreamRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.GetStreamResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.protocol.RangeId;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.protocol.util.StorageContainerPlacementPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.api.kv.TableStore;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.api.metadata.MetaRangeStore;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.api.metadata.RangeStoreService;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.api.metadata.RootRangeStore;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.kv.TableStoreCache;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.kv.TableStoreFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.kv.TableStoreImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.metadata.MetaRangeStoreFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.metadata.MetaRangeStoreImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.metadata.RootRangeStoreFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.metadata.RootRangeStoreImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.service.FailRequestRangeStoreService;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.store.MVCCStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RangeStoreServiceImpl
implements RangeStoreService,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(RangeStoreServiceImpl.class);
    private final long scId;
    private final MVCCStoreFactory storeFactory;
    private MetaRangeStore mgStore;
    private final MetaRangeStoreFactory mrStoreFactory;
    private RootRangeStore rootRange;
    private final RootRangeStoreFactory rrStoreFactory;
    private final TableStoreCache tableStoreCache;
    private final TableStoreFactory tableStoreFactory;

    RangeStoreServiceImpl(long scId, StorageContainerPlacementPolicy rangePlacementPolicy, OrderedScheduler scheduler, MVCCStoreFactory storeFactory, StorageServerClientManager clientManager) {
        this(scId, scheduler, storeFactory, store -> new RootRangeStoreImpl(store, rangePlacementPolicy, scheduler.chooseThread(scId)), store -> new MetaRangeStoreImpl(store, rangePlacementPolicy, scheduler.chooseThread(scId), clientManager), store -> new TableStoreImpl(store));
    }

    RangeStoreServiceImpl(long scId, OrderedScheduler scheduler, MVCCStoreFactory storeFactory, RootRangeStoreFactory rrStoreFactory, MetaRangeStoreFactory mrStoreFactory, TableStoreFactory tableStoreFactory) {
        this.scId = scId;
        RangeStoreService failRequestStorageContainer = FailRequestRangeStoreService.of(scheduler);
        this.rootRange = failRequestStorageContainer;
        this.mgStore = failRequestStorageContainer;
        this.storeFactory = storeFactory;
        this.rrStoreFactory = rrStoreFactory;
        this.mrStoreFactory = mrStoreFactory;
        this.tableStoreFactory = tableStoreFactory;
        this.tableStoreCache = new TableStoreCache(storeFactory, tableStoreFactory);
    }

    public long getId() {
        return this.scId;
    }

    private CompletableFuture<Void> startRootRangeStore() {
        if (0L != this.scId) {
            return FutureUtils.Void();
        }
        return this.storeFactory.openStore(0L, 0L, 0L).thenApply(store -> {
            this.rootRange = this.rrStoreFactory.createStore((MVCCAsyncStore<byte[], byte[]>)store);
            return null;
        });
    }

    private CompletableFuture<Void> startMetaRangeStore(long scId) {
        return this.storeFactory.openStore(scId, 1L, 0L).thenApply(store -> {
            this.mgStore = this.mrStoreFactory.createStore((MVCCAsyncStore<byte[], byte[]>)store);
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> start() {
        ArrayList futures = Lists.newArrayList(this.startRootRangeStore(), this.startMetaRangeStore(this.scId));
        return FutureUtils.collect(futures).thenApply(ignored -> null);
    }

    @Override
    public CompletableFuture<Void> stop() {
        return this.storeFactory.closeStores(this.scId);
    }

    @Override
    public void close() {
        this.stop().join();
    }

    @Override
    public CompletableFuture<CreateNamespaceResponse> createNamespace(CreateNamespaceRequest request) {
        return this.rootRange.createNamespace(request);
    }

    @Override
    public CompletableFuture<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest request) {
        return this.rootRange.deleteNamespace(request);
    }

    @Override
    public CompletableFuture<GetNamespaceResponse> getNamespace(GetNamespaceRequest request) {
        return this.rootRange.getNamespace(request);
    }

    @Override
    public CompletableFuture<CreateStreamResponse> createStream(CreateStreamRequest request) {
        return this.rootRange.createStream(request);
    }

    @Override
    public CompletableFuture<DeleteStreamResponse> deleteStream(DeleteStreamRequest request) {
        return this.rootRange.deleteStream(request);
    }

    @Override
    public CompletableFuture<GetStreamResponse> getStream(GetStreamRequest request) {
        return this.rootRange.getStream(request);
    }

    @Override
    public CompletableFuture<GetActiveRangesResponse> getActiveRanges(GetActiveRangesRequest request) {
        return this.mgStore.getActiveRanges(request);
    }

    @Override
    public CompletableFuture<RangeResponse> range(RangeRequest request) {
        RoutingHeader header = request.getHeader();
        if (header.getRangeId() <= 0L) {
            return CompletableFuture.completedFuture(RangeResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.BAD_REQUEST).setRoutingHeader(request.getHeader()).build()).build());
        }
        RangeId rid = RangeId.of(header.getStreamId(), header.getRangeId());
        TableStore store = this.tableStoreCache.getTableStore(rid);
        if (null != store) {
            return store.range(request);
        }
        return this.tableStoreCache.openTableStore(this.scId, rid).thenCompose(s -> s.range(request));
    }

    @Override
    public CompletableFuture<PutResponse> put(PutRequest request) {
        RoutingHeader header = request.getHeader();
        if (header.getRangeId() <= 0L) {
            return CompletableFuture.completedFuture(PutResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.BAD_REQUEST).setRoutingHeader(request.getHeader()).build()).build());
        }
        RangeId rid = RangeId.of(header.getStreamId(), header.getRangeId());
        TableStore store = this.tableStoreCache.getTableStore(rid);
        if (null != store) {
            return store.put(request);
        }
        return this.tableStoreCache.openTableStore(this.scId, rid).thenCompose(s -> s.put(request));
    }

    @Override
    public CompletableFuture<DeleteRangeResponse> delete(DeleteRangeRequest request) {
        RoutingHeader header = request.getHeader();
        if (header.getRangeId() <= 0L) {
            return CompletableFuture.completedFuture(DeleteRangeResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.BAD_REQUEST).setRoutingHeader(request.getHeader()).build()).build());
        }
        RangeId rid = RangeId.of(header.getStreamId(), header.getRangeId());
        TableStore store = this.tableStoreCache.getTableStore(rid);
        if (null != store) {
            return store.delete(request);
        }
        return this.tableStoreCache.openTableStore(this.scId, rid).thenCompose(s -> s.delete(request));
    }

    @Override
    public CompletableFuture<TxnResponse> txn(TxnRequest request) {
        RoutingHeader header = request.getHeader();
        if (header.getRangeId() <= 0L) {
            return CompletableFuture.completedFuture(TxnResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.BAD_REQUEST).setRoutingHeader(request.getHeader()).build()).build());
        }
        RangeId rid = RangeId.of(header.getStreamId(), header.getRangeId());
        TableStore store = this.tableStoreCache.getTableStore(rid);
        if (null != store) {
            return store.txn(request);
        }
        return this.tableStoreCache.openTableStore(this.scId, rid).thenCompose(s -> s.txn(request));
    }

    @Override
    public CompletableFuture<IncrementResponse> incr(IncrementRequest request) {
        RoutingHeader header = request.getHeader();
        if (header.getRangeId() <= 0L) {
            return CompletableFuture.completedFuture(IncrementResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.BAD_REQUEST).setRoutingHeader(request.getHeader()).build()).build());
        }
        RangeId rid = RangeId.of(header.getStreamId(), header.getRangeId());
        TableStore store = this.tableStoreCache.getTableStore(rid);
        if (null != store) {
            return store.incr(request);
        }
        return this.tableStoreCache.openTableStore(this.scId, rid).thenCompose(s -> s.incr(request));
    }

    MetaRangeStore getMgStore() {
        return this.mgStore;
    }

    MetaRangeStoreFactory getMrStoreFactory() {
        return this.mrStoreFactory;
    }

    RootRangeStore getRootRange() {
        return this.rootRange;
    }

    RootRangeStoreFactory getRrStoreFactory() {
        return this.rrStoreFactory;
    }

    TableStoreCache getTableStoreCache() {
        return this.tableStoreCache;
    }

    TableStoreFactory getTableStoreFactory() {
        return this.tableStoreFactory;
    }
}

