/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.tls;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.pulsar.shade.com.google.common.base.Strings;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.shade.io.netty.handler.ssl.ClientAuth;
import org.apache.pulsar.shade.io.netty.handler.ssl.OpenSsl;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContextBuilder;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslHandler;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.tls.FileModifiedTimeUpdater;
import org.apache.pulsar.shade.org.apache.bookkeeper.tls.SecurityException;
import org.apache.pulsar.shade.org.apache.bookkeeper.tls.SecurityHandlerFactory;
import org.apache.pulsar.shade.org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSContextFactory
implements SecurityHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(TLSContextFactory.class);
    public static final Provider BC_PROVIDER = TLSContextFactory.getProvider();
    public static final String BC_FIPS_PROVIDER_CLASS = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";
    public static final String BC_NON_FIPS_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    public static final String BC_FIPS = "BCFIPS";
    public static final String BC = "BC";
    private static final String TLSCONTEXT_HANDLER_NAME = "tls";
    private String[] protocols;
    private String[] ciphers;
    private volatile SslContext sslContext;
    private ByteBufAllocator allocator;
    private AbstractConfiguration config;
    private FileModifiedTimeUpdater tlsCertificateFilePath;
    private FileModifiedTimeUpdater tlsKeyStoreFilePath;
    private FileModifiedTimeUpdater tlsKeyStorePasswordFilePath;
    private FileModifiedTimeUpdater tlsTrustStoreFilePath;
    private FileModifiedTimeUpdater tlsTrustStorePasswordFilePath;
    private long certRefreshTime;
    private volatile long certLastRefreshTime;
    private boolean isServerCtx;

    public static Provider getProvider() {
        boolean isProviderInstalled;
        boolean bl = isProviderInstalled = Security.getProvider(BC) != null || Security.getProvider(BC_FIPS) != null;
        if (isProviderInstalled) {
            Provider provider;
            Provider provider2 = provider = Security.getProvider(BC) != null ? Security.getProvider(BC) : Security.getProvider(BC_FIPS);
            if (log.isDebugEnabled()) {
                log.debug("Already instantiated Bouncy Castle provider {}", (Object)provider.getName());
            }
            return provider;
        }
        try {
            return TLSContextFactory.getBCProviderFromClassPath();
        }
        catch (Exception e) {
            log.warn("Not able to get Bouncy Castle provider for both FIPS and Non-FIPS from class path:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static Provider getBCProviderFromClassPath() throws Exception {
        Class<?> clazz;
        try {
            clazz = Class.forName(BC_FIPS_PROVIDER_CLASS);
        }
        catch (ClassNotFoundException cnf) {
            if (log.isDebugEnabled()) {
                log.debug("Not able to get Bouncy Castle provider: {}, try to get FIPS provider {}", (Object)BC_NON_FIPS_PROVIDER_CLASS, (Object)BC_FIPS_PROVIDER_CLASS);
            }
            clazz = Class.forName(BC_NON_FIPS_PROVIDER_CLASS);
        }
        Provider provider = (Provider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Security.addProvider(provider);
        if (log.isDebugEnabled()) {
            log.debug("Found and Instantiated Bouncy Castle provider in classpath {}", (Object)provider.getName());
        }
        return provider;
    }

    private String getPasswordFromFile(String path) throws IOException {
        File passwdFile = new File(path);
        if (passwdFile.length() == 0L) {
            return "";
        }
        byte[] pwd = FileUtils.readFileToByteArray(passwdFile);
        return new String(pwd, StandardCharsets.UTF_8);
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="work around for java 9: https://github.com/spotbugs/spotbugs/issues/493")
    private KeyStore loadKeyStore(String keyStoreType, String keyStoreLocation, String keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        try (FileInputStream ksin = new FileInputStream(keyStoreLocation);){
            ks.load(ksin, keyStorePassword.trim().toCharArray());
        }
        return ks;
    }

    @Override
    public String getHandlerName() {
        return TLSCONTEXT_HANDLER_NAME;
    }

    private KeyManagerFactory initKeyManagerFactory(String keyStoreType, String keyStoreLocation, String keyStorePasswordPath) throws SecurityException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, InvalidKeySpecException {
        KeyManagerFactory kmf = null;
        if (Strings.isNullOrEmpty(keyStoreLocation)) {
            log.error("Key store location cannot be empty when Mutual Authentication is enabled!");
            throw new SecurityException("Key store location cannot be empty when Mutual Authentication is enabled!");
        }
        String keyStorePassword = "";
        if (!Strings.isNullOrEmpty(keyStorePasswordPath)) {
            keyStorePassword = this.getPasswordFromFile(keyStorePasswordPath);
        }
        KeyStore ks = this.loadKeyStore(keyStoreType, keyStoreLocation, keyStorePassword);
        kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, keyStorePassword.trim().toCharArray());
        return kmf;
    }

    private TrustManagerFactory initTrustManagerFactory(String trustStoreType, String trustStoreLocation, String trustStorePasswordPath) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, SecurityException {
        if (Strings.isNullOrEmpty(trustStoreLocation)) {
            log.error("Trust Store location cannot be empty!");
            throw new SecurityException("Trust Store location cannot be empty!");
        }
        String trustStorePassword = "";
        if (!Strings.isNullOrEmpty(trustStorePasswordPath)) {
            trustStorePassword = this.getPasswordFromFile(trustStorePasswordPath);
        }
        KeyStore ts = this.loadKeyStore(trustStoreType, trustStoreLocation, trustStorePassword);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        return tmf;
    }

    private SslProvider getTLSProvider(String sslProvider) {
        if (sslProvider.trim().equalsIgnoreCase("OpenSSL")) {
            if (OpenSsl.isAvailable()) {
                log.info("Security provider - OpenSSL");
                return SslProvider.OPENSSL;
            }
            Throwable causeUnavailable = OpenSsl.unavailabilityCause();
            log.warn("OpenSSL Unavailable: ", causeUnavailable);
            log.info("Security provider - JDK");
            return SslProvider.JDK;
        }
        log.info("Security provider - JDK");
        return SslProvider.JDK;
    }

    private void createClientContext() throws SecurityException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, InvalidKeySpecException, NoSuchProviderException {
        ClientConfiguration clientConf = (ClientConfiguration)this.config;
        this.markAutoCertRefresh(clientConf.getTLSCertificatePath(), clientConf.getTLSKeyStore(), clientConf.getTLSKeyStorePasswordPath(), clientConf.getTLSTrustStore(), clientConf.getTLSTrustStorePasswordPath());
        this.updateClientContext();
    }

    private synchronized void updateClientContext() throws SecurityException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, InvalidKeySpecException, NoSuchProviderException {
        SslContextBuilder sslContextBuilder;
        if (!(this.config instanceof ClientConfiguration)) {
            throw new SecurityException("Client configruation not provided");
        }
        ClientConfiguration clientConf = (ClientConfiguration)this.config;
        SslProvider provider = this.getTLSProvider(clientConf.getTLSProvider());
        boolean clientAuthentication = clientConf.getTLSClientAuthentication();
        switch (KeyStoreType.valueOf(clientConf.getTLSTrustStoreType())) {
            case PEM: {
                if (Strings.isNullOrEmpty(clientConf.getTLSTrustStore())) {
                    throw new SecurityException("CA Certificate required");
                }
                sslContextBuilder = SslContextBuilder.forClient().trustManager(new File(clientConf.getTLSTrustStore())).ciphers(null).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(provider).clientAuth(ClientAuth.REQUIRE);
                break;
            }
            case JKS: 
            case PKCS12: {
                TrustManagerFactory tmf = this.initTrustManagerFactory(clientConf.getTLSTrustStoreType(), clientConf.getTLSTrustStore(), clientConf.getTLSTrustStorePasswordPath());
                sslContextBuilder = SslContextBuilder.forClient().trustManager(tmf).ciphers(null).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(provider).clientAuth(ClientAuth.REQUIRE);
                break;
            }
            default: {
                throw new SecurityException("Invalid Truststore type: " + clientConf.getTLSTrustStoreType());
            }
        }
        if (clientAuthentication) {
            switch (KeyStoreType.valueOf(clientConf.getTLSKeyStoreType())) {
                case PEM: {
                    if (Strings.isNullOrEmpty(clientConf.getTLSCertificatePath())) {
                        throw new SecurityException("Valid Certificate is missing");
                    }
                    if (Strings.isNullOrEmpty(clientConf.getTLSKeyStore())) {
                        throw new SecurityException("Valid Key is missing");
                    }
                    String keyPassword = !Strings.isNullOrEmpty(clientConf.getTLSKeyStorePasswordPath()) ? this.getPasswordFromFile(clientConf.getTLSKeyStorePasswordPath()) : null;
                    sslContextBuilder.keyManager(new File(clientConf.getTLSCertificatePath()), new File(clientConf.getTLSKeyStore()), keyPassword);
                    break;
                }
                case JKS: 
                case PKCS12: {
                    KeyManagerFactory kmf = this.initKeyManagerFactory(clientConf.getTLSKeyStoreType(), clientConf.getTLSKeyStore(), clientConf.getTLSKeyStorePasswordPath());
                    sslContextBuilder.keyManager(kmf);
                    break;
                }
                default: {
                    throw new SecurityException("Invalid Keyfile type" + clientConf.getTLSKeyStoreType());
                }
            }
        }
        this.sslContext = sslContextBuilder.build();
        this.certLastRefreshTime = System.currentTimeMillis();
    }

    private void createServerContext() throws SecurityException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, InvalidKeySpecException, IllegalArgumentException {
        this.isServerCtx = true;
        ServerConfiguration clientConf = (ServerConfiguration)this.config;
        this.markAutoCertRefresh(clientConf.getTLSCertificatePath(), clientConf.getTLSKeyStore(), clientConf.getTLSKeyStorePasswordPath(), clientConf.getTLSTrustStore(), clientConf.getTLSTrustStorePasswordPath());
        this.updateServerContext();
    }

    private synchronized SslContext getSSLContext() {
        long now = System.currentTimeMillis();
        if (this.certRefreshTime > 0L && now > this.certLastRefreshTime + this.certRefreshTime && (this.tlsCertificateFilePath.checkAndRefresh() || this.tlsKeyStoreFilePath.checkAndRefresh() || this.tlsKeyStorePasswordFilePath.checkAndRefresh() || this.tlsTrustStoreFilePath.checkAndRefresh() || this.tlsTrustStorePasswordFilePath.checkAndRefresh())) {
            try {
                log.info("Updating tls certs certFile={}, keyStoreFile={}, trustStoreFile={}", new Object[]{this.tlsCertificateFilePath.getFileName(), this.tlsKeyStoreFilePath.getFileName(), this.tlsTrustStoreFilePath.getFileName()});
                if (this.isServerCtx) {
                    this.updateServerContext();
                } else {
                    this.updateClientContext();
                }
            }
            catch (Exception e) {
                log.info("Failed to refresh tls certs", (Throwable)e);
            }
        }
        return this.sslContext;
    }

    private synchronized void updateServerContext() throws SecurityException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, InvalidKeySpecException, IllegalArgumentException {
        SslContextBuilder sslContextBuilder;
        if (!(this.config instanceof ServerConfiguration)) {
            throw new SecurityException("Server configruation not provided");
        }
        ServerConfiguration serverConf = (ServerConfiguration)this.config;
        SslProvider provider = this.getTLSProvider(serverConf.getTLSProvider());
        boolean clientAuthentication = serverConf.getTLSClientAuthentication();
        switch (KeyStoreType.valueOf(serverConf.getTLSKeyStoreType())) {
            case PEM: {
                if (Strings.isNullOrEmpty(serverConf.getTLSKeyStore())) {
                    throw new SecurityException("Key path is required");
                }
                if (Strings.isNullOrEmpty(serverConf.getTLSCertificatePath())) {
                    throw new SecurityException("Certificate path is required");
                }
                String keyPassword = !Strings.isNullOrEmpty(serverConf.getTLSKeyStorePasswordPath()) ? this.getPasswordFromFile(serverConf.getTLSKeyStorePasswordPath()) : null;
                sslContextBuilder = SslContextBuilder.forServer(new File(serverConf.getTLSCertificatePath()), new File(serverConf.getTLSKeyStore()), keyPassword).ciphers(null).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(provider).startTls(true);
                break;
            }
            case JKS: 
            case PKCS12: {
                KeyManagerFactory kmf = this.initKeyManagerFactory(serverConf.getTLSKeyStoreType(), serverConf.getTLSKeyStore(), serverConf.getTLSKeyStorePasswordPath());
                sslContextBuilder = SslContextBuilder.forServer(kmf).ciphers(null).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(provider).startTls(true);
                break;
            }
            default: {
                throw new SecurityException("Invalid Keyfile type" + serverConf.getTLSKeyStoreType());
            }
        }
        if (clientAuthentication) {
            sslContextBuilder.clientAuth(ClientAuth.REQUIRE);
            switch (KeyStoreType.valueOf(serverConf.getTLSTrustStoreType())) {
                case PEM: {
                    if (Strings.isNullOrEmpty(serverConf.getTLSTrustStore())) {
                        throw new SecurityException("CA Certificate chain is required");
                    }
                    sslContextBuilder.trustManager(new File(serverConf.getTLSTrustStore()));
                    break;
                }
                case JKS: 
                case PKCS12: {
                    TrustManagerFactory tmf = this.initTrustManagerFactory(serverConf.getTLSTrustStoreType(), serverConf.getTLSTrustStore(), serverConf.getTLSTrustStorePasswordPath());
                    sslContextBuilder.trustManager(tmf);
                    break;
                }
                default: {
                    throw new SecurityException("Invalid Truststore type" + serverConf.getTLSTrustStoreType());
                }
            }
        }
        this.sslContext = sslContextBuilder.build();
        this.certLastRefreshTime = System.currentTimeMillis();
    }

    @Override
    public synchronized void init(SecurityHandlerFactory.NodeType type, AbstractConfiguration conf, ByteBufAllocator allocator) throws SecurityException {
        this.allocator = allocator;
        this.config = conf;
        this.certRefreshTime = TimeUnit.SECONDS.toMillis(conf.getTLSCertFilesRefreshDurationSeconds());
        String enabledCiphers = conf.getTLSEnabledCipherSuites();
        String enabledProtocols = conf.getTLSEnabledProtocols();
        try {
            switch (type) {
                case Client: {
                    this.createClientContext();
                    break;
                }
                case Server: {
                    this.createServerContext();
                    break;
                }
                default: {
                    throw new SecurityException(new IllegalArgumentException("Invalid NodeType"));
                }
            }
            if (enabledProtocols != null && !enabledProtocols.isEmpty()) {
                this.protocols = enabledProtocols.split(",");
            }
            if (enabledCiphers != null && !enabledCiphers.isEmpty()) {
                this.ciphers = enabledCiphers.split(",");
            }
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Standard keystore type missing", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Standard algorithm missing", e);
        }
        catch (CertificateException e) {
            throw new SecurityException("Unable to load keystore", e);
        }
        catch (IOException e) {
            throw new SecurityException("Error initializing SSLContext", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new SecurityException("Unable to load key manager, possibly bad password", e);
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException("Unable to load key manager", e);
        }
        catch (IllegalArgumentException e) {
            throw new SecurityException("Invalid TLS configuration", e);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException("No such provider", e);
        }
    }

    @Override
    public SslHandler newTLSHandler() {
        SslHandler sslHandler = this.getSSLContext().newHandler(this.allocator);
        if (this.protocols != null && this.protocols.length != 0) {
            sslHandler.engine().setEnabledProtocols(this.protocols);
        }
        if (log.isDebugEnabled()) {
            log.debug("Enabled cipher protocols: {} ", (Object)Arrays.toString(sslHandler.engine().getEnabledProtocols()));
        }
        if (this.ciphers != null && this.ciphers.length != 0) {
            sslHandler.engine().setEnabledCipherSuites(this.ciphers);
        }
        if (log.isDebugEnabled()) {
            log.debug("Enabled cipher suites: {} ", (Object)Arrays.toString(sslHandler.engine().getEnabledCipherSuites()));
        }
        return sslHandler;
    }

    private void markAutoCertRefresh(String tlsCertificatePath, String tlsKeyStore, String tlsKeyStorePasswordPath, String tlsTrustStore, String tlsTrustStorePasswordPath) {
        this.tlsCertificateFilePath = new FileModifiedTimeUpdater(tlsCertificatePath);
        this.tlsKeyStoreFilePath = new FileModifiedTimeUpdater(tlsKeyStore);
        this.tlsKeyStorePasswordFilePath = new FileModifiedTimeUpdater(tlsKeyStorePasswordPath);
        this.tlsTrustStoreFilePath = new FileModifiedTimeUpdater(tlsTrustStore);
        this.tlsTrustStorePasswordFilePath = new FileModifiedTimeUpdater(tlsTrustStorePasswordPath);
    }

    public static enum KeyStoreType {
        PKCS12("PKCS12"),
        JKS("JKS"),
        PEM("PEM");

        private String str;

        private KeyStoreType(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

